/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import java.io.Serializable;
import java.util.Random;
import java.util.Set;

public class MessageContext
implements Serializable {
    private static final long serialVersionUID = -3757195646384786213L;
    private final int sender;
    private final int viewID;
    private final TOMMessageType type;
    private final int session;
    private final int sequence;
    private final int operationId;
    private final int replyServer;
    private final byte[] signature;
    private final long timestamp;
    private final int regency;
    private final int leader;
    private final int consensusId;
    private final int numOfNonces;
    private final long seed;
    private final Set<ConsensusMessage> proof;
    private final TOMMessage firstInBatch;
    private boolean lastInBatch;
    private final boolean noOp;
    public boolean readOnly = false;
    private byte[] nonces = null;

    public MessageContext(int sender, int viewID, TOMMessageType type, int session, int sequence, int operationId, int replyServer, byte[] signature, long timestamp, int numOfNonces, long seed, int regency, int leader, int consensusId, Set<ConsensusMessage> proof, TOMMessage firstInBatch, boolean noOp) {
        this.sender = sender;
        this.viewID = viewID;
        this.type = type;
        this.session = session;
        this.sequence = sequence;
        this.operationId = operationId;
        this.replyServer = replyServer;
        this.signature = signature;
        this.timestamp = timestamp;
        this.regency = regency;
        this.leader = leader;
        this.consensusId = consensusId;
        this.numOfNonces = numOfNonces;
        this.seed = seed;
        this.proof = proof;
        this.firstInBatch = firstInBatch;
        this.noOp = noOp;
    }

    public static long getSerialVersionUID() {
        return -3757195646384786213L;
    }

    public int getViewID() {
        return this.viewID;
    }

    public TOMMessageType getType() {
        return this.type;
    }

    public int getSession() {
        return this.session;
    }

    public int getSequence() {
        return this.sequence;
    }

    public int getOperationId() {
        return this.operationId;
    }

    public int getReplyServer() {
        return this.replyServer;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getSender() {
        return this.sender;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public byte[] getNonces() {
        if (this.nonces == null) {
            this.nonces = new byte[this.numOfNonces];
            if (this.nonces.length > 0) {
                Random rnd = new Random(this.seed);
                rnd.nextBytes(this.nonces);
            }
        }
        return this.nonces;
    }

    public int getNumOfNonces() {
        return this.numOfNonces;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getConsensusId() {
        return this.consensusId;
    }

    public int getLeader() {
        return this.leader;
    }

    public Set<ConsensusMessage> getProof() {
        return this.proof;
    }

    public int getRegency() {
        return this.regency;
    }

    public TOMMessage getFirstInBatch() {
        return this.firstInBatch;
    }

    public void setLastInBatch() {
        this.lastInBatch = true;
    }

    public boolean isLastInBatch() {
        return this.lastInBatch;
    }

    public boolean isNoOp() {
        return this.noOp;
    }

    public TOMMessage recreateTOMMessage(byte[] content) {
        TOMMessage ret = new TOMMessage(this.sender, this.session, this.sequence, this.operationId, content, this.viewID, this.type);
        ret.setReplyServer(this.replyServer);
        ret.serializedMessageSignature = this.signature;
        ret.serializedMessage = TOMMessage.messageToBytes(ret);
        return ret;
    }
}

