/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.tom;

import bftsmart.communication.client.ReplyListener;
import bftsmart.tom.RequestContext;
import bftsmart.tom.ServiceProxy;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Extractor;
import bftsmart.tom.util.Logger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;

public class AsynchServiceProxy
extends ServiceProxy {
    private Hashtable<Integer, RequestContext> requestsContext = new Hashtable();

    public AsynchServiceProxy(int processId) {
        this(processId, null);
        this.requestsContext = new Hashtable();
    }

    public AsynchServiceProxy(int processId, String configHome) {
        super(processId, configHome);
    }

    public AsynchServiceProxy(int processId, String configHome, Comparator<byte[]> replyComparator, Extractor replyExtractor) {
        super(processId, configHome, replyComparator, replyExtractor);
    }

    public int invokeAsynchRequest(byte[] request, ReplyListener replyListener, TOMMessageType reqType) {
        return this.invokeAsynchRequest(request, super.getViewManager().getCurrentViewProcesses(), replyListener, reqType);
    }

    public int invokeAsynchRequest(byte[] request, int[] targets, ReplyListener replyListener, TOMMessageType reqType) {
        return this.invokeAsynch(request, targets, replyListener, reqType);
    }

    public void cleanAsynchRequest(int requestId) {
        this.requestsContext.remove(requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replyReceived(TOMMessage reply) {
        Logger.println("Asynchronously received reply from " + reply.getSender() + " with sequence number " + reply.getSequence());
        try {
            this.canReceiveLock.lock();
            RequestContext requestContext = this.requestsContext.get(reply.getSequence());
            if (requestContext == null) {
                super.replyReceived(reply);
                return;
            }
            if (this.contains(requestContext.getTargets(), reply.getSender()) && reply.getSequence() == requestContext.getReqId() && reply.getReqType().compareTo(requestContext.getRequestType()) == 0) {
                Logger.println("Deliverying message from " + reply.getSender() + " with sequence number " + reply.getSequence() + " to the listener");
                ReplyListener replyListener = requestContext.getReplyListener();
                if (replyListener != null) {
                    requestContext.getReplyListener().replyReceived(requestContext, reply);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.canReceiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int invokeAsynch(byte[] request, int[] targets, ReplyListener replyListener, TOMMessageType reqType) {
        Logger.println("Asynchronously sending request to " + Arrays.toString(targets));
        RequestContext requestContext = null;
        this.canSendLock.lock();
        requestContext = new RequestContext(this.generateRequestId(reqType), this.generateOperationId(), reqType, targets, System.currentTimeMillis(), replyListener);
        try {
            Logger.println("Storing request context for " + requestContext.getReqId());
            this.requestsContext.put(requestContext.getReqId(), requestContext);
            this.sendMessageToTargets(request, requestContext.getReqId(), requestContext.getOperationId(), targets, reqType);
        }
        finally {
            this.canSendLock.unlock();
        }
        return requestContext.getReqId();
    }

    private boolean contains(int[] targets, int senderId) {
        for (int i = 0; i < targets.length; ++i) {
            if (targets[i] != senderId) continue;
            return true;
        }
        return false;
    }
}

