/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy.durability;

import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.reconfiguration.views.View;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.strategy.BaseStateManager;
import bftsmart.statemanagement.strategy.durability.CSTRequestF1;
import bftsmart.statemanagement.strategy.durability.CSTSMMessage;
import bftsmart.statemanagement.strategy.durability.CSTState;
import bftsmart.statemanagement.strategy.durability.StateSenderServer;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.ExecutionManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.server.defaultservices.durability.DurabilityCoordinator;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;

public class DurableStateManager
extends BaseStateManager {
    private ExecutionManager execManager;
    private ReentrantLock lockTimer = new ReentrantLock();
    private Timer stateTimer = null;
    private static final long INIT_TIMEOUT = 40000L;
    private long timeout = 40000L;
    private CSTRequestF1 cstRequest;
    private CSTState stateCkp;
    private CSTState stateLower;
    private CSTState stateUpper;

    @Override
    public void init(TOMLayer tomLayer, DeliveryThread dt) {
        this.SVController = tomLayer.controller;
        this.tomLayer = tomLayer;
        this.dt = dt;
        this.execManager = tomLayer.execManager;
        this.state = null;
        this.lastCID = 1;
        this.waitingCID = -1;
        this.appStateOnly = false;
    }

    @Override
    protected void requestState() {
        if (this.tomLayer.requestsTimer != null) {
            this.tomLayer.requestsTimer.clearAll();
        }
        int myProcessId = this.SVController.getStaticConf().getProcessId();
        int[] otherProcesses = this.SVController.getCurrentViewOtherAcceptors();
        int globalCkpPeriod = this.SVController.getStaticConf().getGlobalCheckpointPeriod();
        CSTRequestF1 cst = new CSTRequestF1(this.waitingCID);
        cst.defineReplicas(otherProcesses, globalCkpPeriod, myProcessId);
        this.cstRequest = cst;
        CSTSMMessage cstMsg = new CSTSMMessage(myProcessId, this.waitingCID, 6, cst, null, null, -1, -1);
        this.tomLayer.getCommunication().send(this.SVController.getCurrentViewOtherAcceptors(), cstMsg);
        System.out.println("(TOMLayer.requestState) I just sent a request to the other replicas for the state up to CID " + this.waitingCID);
        TimerTask stateTask = new TimerTask(){

            @Override
            public void run() {
                int[] myself = new int[]{DurableStateManager.this.SVController.getStaticConf().getProcessId()};
                DurableStateManager.this.tomLayer.getCommunication().send(myself, new CSTSMMessage(-1, DurableStateManager.this.waitingCID, 9, null, null, null, -1, -1));
            }
        };
        this.stateTimer = new Timer("state timer");
        this.timeout *= 2L;
        this.stateTimer.schedule(stateTask, this.timeout);
    }

    @Override
    public void stateTimeout() {
        this.lockTimer.lock();
        Logger.println("(StateManager.stateTimeout) Timeout for the replica that was supposed to send the complete state. Changing desired replica.");
        System.out.println("Timeout no timer do estado!");
        if (this.stateTimer != null) {
            this.stateTimer.cancel();
        }
        this.reset();
        this.requestState();
        this.lockTimer.unlock();
    }

    @Override
    public void SMRequestDeliver(SMMessage msg, boolean isBFT) {
        System.out.println("(TOMLayer.SMRequestDeliver) invoked method");
        Logger.println("(TOMLayer.SMRequestDeliver) invoked method");
        if (this.SVController.getStaticConf().isStateTransferEnabled() && this.dt.getRecoverer() != null) {
            boolean sendState;
            Logger.println("(TOMLayer.SMRequestDeliver) The state transfer protocol is enabled");
            Logger.println("(TOMLayer.SMRequestDeliver) I received a state request for CID " + msg.getCID() + " from replica " + msg.getSender());
            CSTSMMessage cstMsg = (CSTSMMessage)msg;
            CSTRequestF1 cstConfig = cstMsg.getCstConfig();
            boolean bl = sendState = cstConfig.getCheckpointReplica() == this.SVController.getStaticConf().getProcessId();
            if (sendState) {
                Logger.println("(TOMLayer.SMRequestDeliver) I should be the one sending the state");
            }
            System.out.println("--- state asked");
            int[] targets = new int[]{msg.getSender()};
            InetSocketAddress address = this.SVController.getCurrentView().getAddress(this.SVController.getStaticConf().getProcessId());
            String myIp = address.getHostName();
            int myId = this.SVController.getStaticConf().getProcessId();
            int port = 4444 + myId;
            address = new InetSocketAddress(myIp, port);
            cstConfig.setAddress(address);
            CSTSMMessage reply = new CSTSMMessage(myId, msg.getCID(), 7, cstConfig, null, this.SVController.getCurrentView(), this.tomLayer.getSynchronizer().getLCManager().getLastReg(), this.tomLayer.execManager.getCurrentLeader());
            StateSenderServer stateServer = new StateSenderServer(port);
            stateServer.setRecoverable(this.dt.getRecoverer());
            stateServer.setRequest(cstConfig);
            new Thread(stateServer).start();
            this.tomLayer.getCommunication().send(targets, reply);
        }
    }

    @Override
    public void SMReplyDeliver(SMMessage msg, boolean isBFT) {
        this.lockTimer.lock();
        CSTSMMessage reply = (CSTSMMessage)msg;
        if (this.SVController.getStaticConf().isStateTransferEnabled()) {
            Logger.println("(TOMLayer.SMReplyDeliver) The state transfer protocol is enabled");
            System.out.println("(TOMLayer.SMReplyDeliver) I received a state reply for CID " + reply.getCID() + " from replica " + reply.getSender());
            System.out.println("--- Received CID: " + reply.getCID() + ". Waiting " + this.waitingCID);
            if (this.waitingCID != -1 && reply.getCID() == this.waitingCID) {
                int currentRegency = -1;
                int currentLeader = -1;
                View currentView = null;
                if (!this.appStateOnly) {
                    this.senderRegencies.put(reply.getSender(), reply.getRegency());
                    this.senderLeaders.put(reply.getSender(), reply.getLeader());
                    this.senderViews.put(reply.getSender(), reply.getView());
                    if (this.enoughRegencies(reply.getRegency())) {
                        currentRegency = reply.getRegency();
                    }
                    if (this.enoughLeaders(reply.getLeader())) {
                        currentLeader = reply.getLeader();
                    }
                    if (this.enoughViews(reply.getView()) && !(currentView = reply.getView()).isMember(this.SVController.getStaticConf().getProcessId())) {
                        System.out.println("Not a member!");
                    }
                } else {
                    currentLeader = this.tomLayer.execManager.getCurrentLeader();
                    currentRegency = this.tomLayer.getSynchronizer().getLCManager().getLastReg();
                    currentView = this.SVController.getCurrentView();
                }
                Logger.println("(TOMLayer.SMReplyDeliver) The reply is for the CID that I want!");
                InetSocketAddress address = reply.getCstConfig().getAddress();
                ApplicationState stateReceived = null;
                try {
                    Socket clientSocket = new Socket(address.getHostName(), address.getPort());
                    ObjectInputStream in = new ObjectInputStream(clientSocket.getInputStream());
                    stateReceived = (ApplicationState)in.readObject();
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                if (stateReceived instanceof CSTState) {
                    this.senderStates.put(reply.getSender(), stateReceived);
                    if (reply.getSender() == this.cstRequest.getCheckpointReplica()) {
                        this.stateCkp = (CSTState)stateReceived;
                    }
                    if (reply.getSender() == this.cstRequest.getLogLower()) {
                        this.stateLower = (CSTState)stateReceived;
                    }
                    if (reply.getSender() == this.cstRequest.getLogUpper()) {
                        this.stateUpper = (CSTState)stateReceived;
                    }
                }
                if (this.senderStates.size() == 3) {
                    CommandsInfo[] lowerLog = this.stateLower.getLogLower();
                    CommandsInfo[] upperLog = this.stateUpper.getLogUpper();
                    System.out.print("lowerLog ");
                    if (lowerLog != null) {
                        System.out.println(lowerLog.length);
                    }
                    System.out.print("upperLog ");
                    if (upperLog != null) {
                        System.out.println(upperLog.length);
                    }
                    boolean haveState = false;
                    byte[] lowerbytes = TOMUtil.getBytes(lowerLog);
                    System.out.println("Log lower bytes size: " + lowerbytes.length);
                    byte[] upperbytes = TOMUtil.getBytes(upperLog);
                    System.out.println("Log upper bytes size: " + upperbytes.length);
                    byte[] lowerLogHash = TOMUtil.computeHash(lowerbytes);
                    byte[] upperLogHash = TOMUtil.computeHash(upperbytes);
                    if (Arrays.equals(this.stateCkp.getHashLogLower(), lowerLogHash)) {
                        haveState = true;
                    } else {
                        System.out.println("Lower log don't match");
                    }
                    if (!haveState || !Arrays.equals(this.stateCkp.getHashLogUpper(), upperLogHash)) {
                        haveState = false;
                        System.out.println("Upper log don't match");
                    }
                    CSTState statePlusLower = new CSTState(this.stateCkp.getSerializedState(), TOMUtil.getBytes(this.stateCkp.getSerializedState()), this.stateLower.getLogLower(), this.stateCkp.getHashLogLower(), null, null, this.stateCkp.getCheckpointCID(), this.stateUpper.getCheckpointCID(), this.SVController.getStaticConf().getProcessId());
                    if (haveState) {
                        System.out.println("validating checkpoint!!!");
                        this.dt.getRecoverer().setState(statePlusLower);
                        byte[] currentStateHash = ((DurabilityCoordinator)this.dt.getRecoverer()).getCurrentStateHash();
                        if (!Arrays.equals(currentStateHash, this.stateUpper.getHashCheckpoint())) {
                            System.out.println("ckp hash don't match");
                            haveState = false;
                        }
                    }
                    System.out.println("-- current regency: " + currentRegency);
                    System.out.println("-- current leader: " + currentLeader);
                    System.out.println("-- current view: " + currentView);
                    if (currentRegency > -1 && currentLeader > -1 && currentView != null && haveState && (!isBFT || this.appStateOnly)) {
                        System.out.println("---- RECEIVED VALID STATE ----");
                        Logger.println("(TOMLayer.SMReplyDeliver) The state of those replies is good!");
                        Logger.println("(TOMLayer.SMReplyDeliver) CID State requested: " + reply.getCID());
                        Logger.println("(TOMLayer.SMReplyDeliver) CID State received: " + this.stateUpper.getLastCID());
                        this.tomLayer.getSynchronizer().getLCManager().setLastReg(currentRegency);
                        this.tomLayer.getSynchronizer().getLCManager().setNextReg(currentRegency);
                        this.tomLayer.getSynchronizer().getLCManager().setNewLeader(currentLeader);
                        this.tomLayer.execManager.setNewLeader(currentLeader);
                        if (currentRegency > 0) {
                            this.tomLayer.getSynchronizer().removeSTOPretransmissions(currentRegency - 1);
                        }
                        System.out.print("trying to acquire deliverlock");
                        this.dt.deliverLock();
                        System.out.println("acquired");
                        this.waitingCID = -1;
                        this.dt.update(this.stateUpper);
                        if (!this.appStateOnly && this.execManager.stopped()) {
                            Queue<ConsensusMessage> stoppedMsgs = this.execManager.getStoppedMsgs();
                            for (ConsensusMessage stopped : stoppedMsgs) {
                                if (stopped.getNumber() <= this.state.getLastCID()) continue;
                                this.execManager.addOutOfContextMessage(stopped);
                            }
                            this.execManager.clearStopped();
                            this.execManager.restart();
                        }
                        System.out.println("Processing out of context messages");
                        this.tomLayer.processOutOfContext();
                        if (this.SVController.getCurrentViewId() != currentView.getId()) {
                            System.out.println("Installing current view!");
                            this.SVController.reconfigureTo(currentView);
                        }
                        this.isInitializing = false;
                        this.dt.canDeliver();
                        this.dt.deliverUnlock();
                        this.reset();
                        System.out.println("I updated the state!");
                        this.tomLayer.requestsTimer.Enabled(true);
                        this.tomLayer.requestsTimer.startTimer();
                        if (this.stateTimer != null) {
                            this.stateTimer.cancel();
                        }
                        if (this.appStateOnly) {
                            this.appStateOnly = false;
                            this.tomLayer.getSynchronizer().resumeLC();
                        }
                    } else if (this.state == null && this.SVController.getCurrentViewN() / 2 < this.getReplies()) {
                        System.out.println("---- DIDNT RECEIVE STATE ----");
                        Logger.println("(TOMLayer.SMReplyDeliver) I have more than " + this.SVController.getCurrentViewN() / 2 + " messages that are no good!");
                        this.waitingCID = -1;
                        this.reset();
                        if (this.stateTimer != null) {
                            this.stateTimer.cancel();
                        }
                        if (this.appStateOnly) {
                            this.requestState();
                        }
                    } else if (!haveState) {
                        System.out.println("---- RECEIVED INVALID STATE  ----");
                        Logger.println("(TOMLayer.SMReplyDeliver) The replica from which I expected the state, sent one which doesn't match the hash of the others, or it never sent it at all");
                        this.reset();
                        this.requestState();
                        if (this.stateTimer != null) {
                            this.stateTimer.cancel();
                        }
                    }
                }
            }
        }
        this.lockTimer.unlock();
    }
}

