/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy.durability;

import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.CertifiedDecision;
import bftsmart.tom.server.defaultservices.CommandsInfo;
import bftsmart.tom.util.BatchBuilder;
import java.util.LinkedList;
import java.util.Set;

public class CSTState
implements ApplicationState {
    private static final long serialVersionUID = -7624656762922101703L;
    private final byte[] hashLogUpper;
    private final byte[] hashLogLower;
    private final byte[] hashCheckpoint;
    private final int checkpointCID;
    private final int lastCID;
    private final CommandsInfo[] logUpper;
    private final CommandsInfo[] logLower;
    private byte[] state;
    private final int pid;

    public CSTState(byte[] state, byte[] hashCheckpoint, CommandsInfo[] logLower, byte[] hashLogLower, CommandsInfo[] logUpper, byte[] hashLogUpper, int checkpointCID, int lastCID, int pid) {
        this.setSerializedState(state);
        this.hashLogUpper = hashLogUpper;
        this.hashLogLower = hashLogLower;
        this.hashCheckpoint = hashCheckpoint;
        this.logUpper = logUpper;
        this.logLower = logLower;
        this.checkpointCID = checkpointCID;
        this.lastCID = lastCID;
        this.pid = pid;
    }

    @Override
    public boolean hasState() {
        return this.getSerializedState() != null;
    }

    @Override
    public byte[] getSerializedState() {
        return this.state;
    }

    @Override
    public byte[] getStateHash() {
        return this.hashCheckpoint;
    }

    @Override
    public void setSerializedState(byte[] state) {
        this.state = state;
    }

    @Override
    public int getLastCID() {
        return this.lastCID;
    }

    @Override
    public CertifiedDecision getCertifiedDecision(ServerViewController controller) {
        CommandsInfo ci = this.getMessageBatch(this.getLastCID());
        if (ci != null && ci.msgCtx[0].getProof() != null) {
            Set<ConsensusMessage> proof = ci.msgCtx[0].getProof();
            LinkedList<TOMMessage> requests = new LinkedList<TOMMessage>();
            for (int i = 0; i < ci.commands.length; ++i) {
                requests.add(ci.msgCtx[i].recreateTOMMessage(ci.commands[i]));
            }
            BatchBuilder bb = new BatchBuilder(0L);
            byte[] value = bb.makeBatch(requests, ci.msgCtx[0].getNumOfNonces(), ci.msgCtx[0].getSeed(), ci.msgCtx[0].getTimestamp(), controller);
            return new CertifiedDecision(this.pid, this.getLastCID(), value, proof);
        }
        return null;
    }

    public int getCheckpointCID() {
        return this.checkpointCID;
    }

    public CommandsInfo getMessageBatch(int cid) {
        if (cid >= this.checkpointCID && cid <= this.lastCID) {
            if (this.logLower != null) {
                return this.logLower[cid - this.checkpointCID - 1];
            }
            if (this.logUpper != null) {
                return this.logUpper[cid - this.checkpointCID - 1];
            }
            return null;
        }
        return null;
    }

    public byte[] getHashLogUpper() {
        return this.hashLogUpper;
    }

    public byte[] getHashLogLower() {
        return this.hashLogLower;
    }

    public CommandsInfo[] getLogUpper() {
        return this.logUpper;
    }

    public CommandsInfo[] getLogLower() {
        return this.logLower;
    }

    public byte[] getHashCheckpoint() {
        return this.hashCheckpoint;
    }
}

