/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy.durability;

import bftsmart.statemanagement.strategy.durability.CSTRequest;

public class CSTRequestFGT1
extends CSTRequest {
    private static final long serialVersionUID = 7661647491651173164L;
    private int hashesReplica;
    private int nbrHashesBeforeCkp;
    private int logSize;

    public CSTRequestFGT1(int cid) {
        super(cid);
    }

    public int getHashesReplica() {
        return this.hashesReplica;
    }

    public int getNbrHashesBeforeCkp() {
        return this.nbrHashesBeforeCkp;
    }

    public int getLogSize() {
        return this.logSize;
    }

    @Override
    public void defineReplicas(int[] processes, int globalCkpPeriod, int replicaId) {
        int N = processes.length;
        int ckpPeriod = globalCkpPeriod / N;
        int logSize = (this.cid + 1) % ckpPeriod;
        int indexCkpReplica = (this.getCID() - ckpPeriod) % globalCkpPeriod / ckpPeriod % N;
        this.hashesReplica = processes[indexCkpReplica];
        this.checkpointReplica = processes[(indexCkpReplica + (N - 1)) % N];
        this.nbrHashesBeforeCkp = ckpPeriod;
        logSize += ckpPeriod;
        if (this.checkpointReplica == replicaId) {
            this.checkpointReplica = processes[(indexCkpReplica + (N - 2)) % N];
            this.nbrHashesBeforeCkp = 2 * ckpPeriod;
            logSize += ckpPeriod;
        } else if (this.hashesReplica == replicaId) {
            this.hashesReplica = processes[(indexCkpReplica + (N - 1)) % N];
            this.checkpointReplica = processes[(indexCkpReplica + (N - 2)) % N];
            logSize += ckpPeriod;
        }
        this.logSize = logSize;
    }
}

