/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy.durability;

import bftsmart.statemanagement.strategy.durability.CSTRequest;
import java.net.InetSocketAddress;

public class CSTRequestF1
extends CSTRequest {
    private static final long serialVersionUID = 6298204287341984504L;
    private int logUpper;
    private int logLower;
    private int ckpPeriod;
    private int logUpperSize;
    private int logLowerSize;
    private InetSocketAddress address;

    public CSTRequestF1(int cid) {
        super(cid);
    }

    public int getLogUpper() {
        return this.logUpper;
    }

    public void setLogUpper(int logUpper) {
        this.logUpper = logUpper;
    }

    public int getLogLower() {
        return this.logLower;
    }

    public void setLogLower(int logLower) {
        this.logLower = logLower;
    }

    public int getLogUpperSize() {
        return this.logUpperSize;
    }

    @Override
    public void defineReplicas(int[] otherReplicas, int globalCkpPeriod, int me) {
        int N = otherReplicas.length + 1;
        this.logLowerSize = this.ckpPeriod = globalCkpPeriod / N;
        this.logUpperSize = (this.cid + 1) % this.ckpPeriod;
        int oldestReplicaPosition = this.getOldest(otherReplicas, this.cid, globalCkpPeriod, me);
        this.logLower = otherReplicas[oldestReplicaPosition];
        this.checkpointReplica = otherReplicas[(oldestReplicaPosition + 1) % otherReplicas.length];
        this.logUpper = otherReplicas[(oldestReplicaPosition + 2) % otherReplicas.length];
    }

    private int getOldest(int[] others, int cid, int globalCheckpointPeriod, int me) {
        int N = others.length + 1;
        int oldestCkpReplica = cid % globalCheckpointPeriod / (globalCheckpointPeriod / N);
        if (oldestCkpReplica == me) {
            oldestCkpReplica = (oldestCkpReplica + 1) % N;
        } else if ((oldestCkpReplica + 3) % N == me) {
            this.logUpperSize = (cid + 1) % this.ckpPeriod + this.ckpPeriod;
        } else if ((oldestCkpReplica + 2) % N == me) {
            this.logLowerSize = 2 * this.ckpPeriod;
        }
        for (int i = 0; i < others.length; ++i) {
            if (others[i] != oldestCkpReplica) continue;
            return i;
        }
        return -1;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public int getLogLowerSize() {
        return this.logLowerSize;
    }
}

