/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.statemanagement.strategy;

import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.views.View;
import bftsmart.statemanagement.ApplicationState;
import bftsmart.statemanagement.SMMessage;
import bftsmart.statemanagement.StateManager;
import bftsmart.statemanagement.strategy.StandardSMMessage;
import bftsmart.tom.core.DeliveryThread;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.leaderchange.CertifiedDecision;
import bftsmart.tom.leaderchange.LCManager;
import bftsmart.tom.util.Logger;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;

public abstract class BaseStateManager
implements StateManager {
    protected TOMLayer tomLayer;
    protected ServerViewController SVController;
    protected DeliveryThread dt;
    protected HashMap<Integer, ApplicationState> senderStates = new HashMap();
    protected HashMap<Integer, View> senderViews = new HashMap();
    protected HashMap<Integer, Integer> senderRegencies = new HashMap();
    protected HashMap<Integer, Integer> senderLeaders = new HashMap();
    protected HashMap<Integer, CertifiedDecision> senderProofs = new HashMap();
    protected boolean appStateOnly;
    protected int waitingCID = -1;
    protected int lastCID;
    protected ApplicationState state;
    protected boolean isInitializing = true;
    private HashMap<Integer, Integer> senderCIDs = null;

    protected int getReplies() {
        return this.senderStates.size();
    }

    protected boolean enoughReplies() {
        return this.senderStates.size() > this.SVController.getCurrentViewF();
    }

    protected boolean enoughRegencies(int regency) {
        return this.senderRegencies.size() > this.SVController.getQuorum();
    }

    protected boolean enoughLeaders(int leader) {
        return this.senderLeaders.size() > this.SVController.getQuorum();
    }

    protected boolean enoughViews(View view) {
        Collection<View> views = this.senderViews.values();
        int counter = 0;
        for (View v : views) {
            if (!view.equals(v)) continue;
            ++counter;
        }
        boolean result = counter > this.SVController.getQuorum();
        return result;
    }

    private int proofIsConsistent(Set<ConsensusMessage> proof) {
        int id = -1;
        byte[] value = null;
        for (ConsensusMessage cm : proof) {
            if (id == -1) {
                id = cm.getNumber();
            }
            if (value == null) {
                value = cm.getValue();
            }
            if (id == cm.getNumber() && Arrays.equals(value, cm.getValue())) continue;
            return -1;
        }
        if (id == -1 || value == null) {
            return -1;
        }
        return id;
    }

    protected boolean enoughProofs(int cid, LCManager lc) {
        int counter = 0;
        for (CertifiedDecision cDec : this.senderProofs.values()) {
            if (cDec == null || cid != this.proofIsConsistent(cDec.getConsMessages()) || !lc.hasValidProof(cDec)) continue;
            ++counter;
        }
        boolean result = counter > this.SVController.getQuorum();
        return result;
    }

    protected void reset() {
        this.senderStates.clear();
        this.senderLeaders.clear();
        this.senderRegencies.clear();
        this.senderViews.clear();
        this.senderProofs.clear();
        this.state = null;
    }

    public Collection<ApplicationState> receivedStates() {
        return this.senderStates.values();
    }

    @Override
    public void setLastCID(int cid) {
        this.lastCID = cid;
    }

    @Override
    public int getLastCID() {
        return this.lastCID;
    }

    @Override
    public void requestAppState(int cid) {
        this.lastCID = cid + 1;
        this.waitingCID = cid;
        System.out.println("waitingcid is now " + cid);
        this.appStateOnly = true;
        this.requestState();
    }

    @Override
    public void analyzeState(int cid) {
        Logger.println("(TOMLayer.analyzeState) The state transfer protocol is enabled");
        if (this.waitingCID == -1) {
            Logger.println("(TOMLayer.analyzeState) I'm not waiting for any state, so I will keep record of this message");
            if (this.tomLayer.execManager.isDecidable(cid)) {
                System.out.println("BaseStateManager.analyzeState: I have now more than " + this.SVController.getCurrentViewF() + " messages for CID " + cid + " which are beyond CID " + this.lastCID);
                this.lastCID = cid;
                this.waitingCID = cid - 1;
                System.out.println("analyzeState " + this.waitingCID);
                this.requestState();
            }
        }
    }

    @Override
    public abstract void init(TOMLayer var1, DeliveryThread var2);

    @Override
    public boolean isRetrievingState() {
        if (this.isInitializing) {
            return true;
        }
        return this.waitingCID > -1;
    }

    @Override
    public void askCurrentConsensusId() {
        int me = this.SVController.getStaticConf().getProcessId();
        int[] target = this.SVController.getCurrentViewAcceptors();
        StandardSMMessage currentCID = new StandardSMMessage(me, -1, 11, 0, null, null, 0, 0);
        this.tomLayer.getCommunication().send(target, currentCID);
        target = this.SVController.getCurrentViewOtherAcceptors();
        while (this.isInitializing) {
            this.tomLayer.getCommunication().send(target, currentCID);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void currentConsensusIdAsked(int sender) {
        int me = this.SVController.getStaticConf().getProcessId();
        int lastConsensusId = this.tomLayer.getLastExec();
        StandardSMMessage currentCIDReply = new StandardSMMessage(me, lastConsensusId, 12, 0, null, null, 0, 0);
        this.tomLayer.getCommunication().send(new int[]{sender}, currentCIDReply);
    }

    @Override
    public synchronized void currentConsensusIdReceived(SMMessage smsg) {
        if (!this.isInitializing || this.waitingCID > -1) {
            return;
        }
        if (this.senderCIDs == null) {
            this.senderCIDs = new HashMap();
        }
        this.senderCIDs.put(smsg.getSender(), smsg.getCID());
        if (this.senderCIDs.size() >= this.SVController.getQuorum()) {
            HashMap<Integer, Integer> cids = new HashMap<Integer, Integer>();
            for (int id : this.senderCIDs.keySet()) {
                int value = this.senderCIDs.get(id);
                Integer count = (Integer)cids.get(value);
                if (count == null) {
                    cids.put(value, 0);
                    continue;
                }
                cids.put(value, count + 1);
            }
            for (int key : cids.keySet()) {
                if ((Integer)cids.get(key) < this.SVController.getQuorum()) continue;
                if (key == this.lastCID) {
                    System.out.println("-- Replica state is up to date");
                    this.dt.deliverLock();
                    this.isInitializing = false;
                    this.tomLayer.setLastExec(key);
                    this.dt.canDeliver();
                    this.dt.deliverUnlock();
                    break;
                }
                System.out.println("-- Requesting state from other replicas");
                this.lastCID = key + 1;
                if (this.waitingCID != -1) continue;
                this.waitingCID = key;
                this.requestState();
            }
        }
    }

    protected abstract void requestState();

    @Override
    public abstract void stateTimeout();

    @Override
    public abstract void SMRequestDeliver(SMMessage var1, boolean var2);

    @Override
    public abstract void SMReplyDeliver(SMMessage var1, boolean var2);
}

