/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;

public class HostsConfig {
    private Hashtable servers = new Hashtable();

    public HostsConfig(String configHome, String fileName) {
        this.loadConfig(configHome, fileName);
    }

    private void loadConfig(String configHome, String fileName) {
        try {
            String path = "";
            String sep = System.getProperty("file.separator");
            path = configHome.equals("") ? (fileName.equals("") ? "config" + sep + "hosts.config" : "config" + sep + fileName) : (fileName.equals("") ? configHome + sep + "hosts.config" : configHome + sep + fileName);
            FileReader fr = new FileReader(path);
            BufferedReader rd = new BufferedReader(fr);
            String line = null;
            while ((line = rd.readLine()) != null) {
                StringTokenizer str;
                if (line.startsWith("#") || (str = new StringTokenizer(line, " ")).countTokens() <= 2) continue;
                int id = Integer.valueOf(str.nextToken());
                String host = str.nextToken();
                int port = Integer.valueOf(str.nextToken());
                this.servers.put(id, new Config(id, host, port));
            }
            fr.close();
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public void add(int id, String host, int port) {
        if (this.servers.get(id) == null) {
            this.servers.put(id, new Config(id, host, port));
        }
    }

    public int getNum() {
        return this.servers.size();
    }

    public InetSocketAddress getRemoteAddress(int id) {
        Config c = (Config)this.servers.get(id);
        if (c != null) {
            return new InetSocketAddress(c.host, c.port);
        }
        return null;
    }

    public InetSocketAddress getServerToServerRemoteAddress(int id) {
        Config c = (Config)this.servers.get(id);
        if (c != null) {
            return new InetSocketAddress(c.host, c.port + 1);
        }
        return null;
    }

    public int getPort(int id) {
        Config c = (Config)this.servers.get(id);
        if (c != null) {
            return c.port;
        }
        return -1;
    }

    public int getServerToServerPort(int id) {
        Config c = (Config)this.servers.get(id);
        if (c != null) {
            return c.port + 1;
        }
        return -1;
    }

    public int[] getHostsIds() {
        Set s = this.servers.keySet();
        int[] ret = new int[s.size()];
        Iterator it = s.iterator();
        int p = 0;
        while (it.hasNext()) {
            ret[p] = Integer.parseInt(it.next().toString());
            ++p;
        }
        return ret;
    }

    public void setPort(int id, int port) {
        Config c = (Config)this.servers.get(id);
        if (c != null) {
            c.port = port;
        }
    }

    public String getHost(int id) {
        Config c = (Config)this.servers.get(id);
        if (c != null) {
            return c.host;
        }
        return null;
    }

    public InetSocketAddress getLocalAddress(int id) {
        Config c = (Config)this.servers.get(id);
        if (c != null) {
            return new InetSocketAddress(c.port);
        }
        return null;
    }

    public class Config {
        public int id;
        public String host;
        public int port;

        public Config(int id, String host, int port) {
            this.id = id;
            this.host = host;
            this.port = port;
        }
    }
}

