/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration.util;

import bftsmart.reconfiguration.util.HostsConfig;
import java.io.BufferedReader;
import java.io.FileReader;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;

public class Configuration {
    protected int processId;
    protected boolean channelsBlocking;
    protected BigInteger DH_P;
    protected BigInteger DH_G;
    protected int autoConnectLimit;
    protected Map<String, String> configs;
    protected HostsConfig hosts;
    private String hmacAlgorithm = "HmacSha1";
    private int hmacSize = 160;
    protected static String configHome = "";
    protected static String hostsFileName = "";
    protected boolean defaultKeys = false;

    public Configuration(int procId) {
        this.processId = procId;
        this.init();
    }

    public Configuration(int processId, String configHomeParam) {
        this.processId = processId;
        configHome = configHomeParam;
        this.init();
    }

    public Configuration(int processId, String configHomeParam, String hostsFileNameParam) {
        this.processId = processId;
        configHome = configHomeParam;
        hostsFileName = hostsFileNameParam;
        this.init();
    }

    protected void init() {
        try {
            this.hosts = new HostsConfig(configHome, hostsFileName);
            this.loadConfig();
            String s = this.configs.remove("system.autoconnect");
            this.autoConnectLimit = s == null ? -1 : Integer.parseInt(s);
            s = this.configs.remove("system.channels.blocking");
            this.channelsBlocking = s == null ? false : s.equalsIgnoreCase("true");
            s = this.configs.remove("system.communication.defaultkeys");
            this.defaultKeys = s == null ? false : s.equalsIgnoreCase("true");
            s = this.configs.remove("system.diffie-hellman.p");
            if (s == null) {
                String pHexString = "FFFFFFFF FFFFFFFF C90FDAA2 2168C234 C4C6628B 80DC1CD129024E08 8A67CC74 020BBEA6 3B139B22 514A0879 8E3404DDEF9519B3 CD3A431B 302B0A6D F25F1437 4FE1356D 6D51C245E485B576 625E7EC6 F44C42E9 A637ED6B 0BFF5CB6 F406B7EDEE386BFB 5A899FA5 AE9F2411 7C4B1FE6 49286651 ECE65381FFFFFFFF FFFFFFFF";
                this.DH_P = new BigInteger(pHexString.replaceAll(" ", ""), 16);
            } else {
                this.DH_P = new BigInteger(s, 16);
            }
            s = this.configs.remove("system.diffie-hellman.g");
            this.DH_G = s == null ? new BigInteger("2") : new BigInteger(s);
        }
        catch (Exception e) {
            System.err.println("Wrong system.config file format.");
            e.printStackTrace(System.out);
        }
    }

    public boolean useDefaultKeys() {
        return this.defaultKeys;
    }

    public final boolean isHostSetted(int id) {
        return this.hosts.getHost(id) != null;
    }

    public final boolean useBlockingChannels() {
        return this.channelsBlocking;
    }

    public final int getAutoConnectLimit() {
        return this.autoConnectLimit;
    }

    public final BigInteger getDHP() {
        return this.DH_P;
    }

    public final BigInteger getDHG() {
        return this.DH_G;
    }

    public final String getHmacAlgorithm() {
        return this.hmacAlgorithm;
    }

    public final int getHmacSize() {
        return this.hmacSize;
    }

    public final String getProperty(String key) {
        String o = this.configs.get(key);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public final Map<String, String> getProperties() {
        return this.configs;
    }

    public final InetSocketAddress getRemoteAddress(int id) {
        return this.hosts.getRemoteAddress(id);
    }

    public final InetSocketAddress getServerToServerRemoteAddress(int id) {
        return this.hosts.getServerToServerRemoteAddress(id);
    }

    public final InetSocketAddress getLocalAddress(int id) {
        return this.hosts.getLocalAddress(id);
    }

    public final String getHost(int id) {
        return this.hosts.getHost(id);
    }

    public final int getPort(int id) {
        return this.hosts.getPort(id);
    }

    public final int getServerToServerPort(int id) {
        return this.hosts.getServerToServerPort(id);
    }

    public final int getProcessId() {
        return this.processId;
    }

    public final void setProcessId(int processId) {
        this.processId = processId;
    }

    public final void addHostInfo(int id, String host, int port) {
        this.hosts.add(id, host, port);
    }

    private void loadConfig() {
        this.configs = new Hashtable<String, String>();
        try {
            if (configHome == null || configHome.equals("")) {
                configHome = "config";
            }
            String sep = System.getProperty("file.separator");
            String path = configHome + sep + "system.config";
            FileReader fr = new FileReader(path);
            BufferedReader rd = new BufferedReader(fr);
            String line = null;
            while ((line = rd.readLine()) != null) {
                StringTokenizer str;
                if (line.startsWith("#") || (str = new StringTokenizer(line, "=")).countTokens() <= 1) continue;
                this.configs.put(str.nextToken().trim(), str.nextToken().trim());
            }
            fr.close();
            rd.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

