/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import bftsmart.communication.server.ServerConnection;
import bftsmart.reconfiguration.Reconfiguration;
import bftsmart.reconfiguration.ReconfigureReply;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.VMMessage;
import bftsmart.reconfiguration.views.View;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ViewManager {
    private int id;
    private Reconfiguration rec = null;
    private ServerViewController controller;
    private List<Integer> addIds = new LinkedList<Integer>();

    public ViewManager() {
        this("");
    }

    public ViewManager(String configHome) {
        this.id = this.loadID(configHome);
        this.controller = new ServerViewController(this.id, configHome);
        this.rec = new Reconfiguration(this.id);
    }

    public void connect() {
        this.rec.connect();
    }

    private int loadID(String configHome) {
        try {
            String path = "";
            String sep = System.getProperty("file.separator");
            path = configHome == null || configHome.equals("") ? "config" + sep + "system.config" : configHome + sep + "system.config";
            FileReader fr = new FileReader(path);
            BufferedReader rd = new BufferedReader(fr);
            String line = null;
            while ((line = rd.readLine()) != null) {
                StringTokenizer str;
                if (line.startsWith("#") || (str = new StringTokenizer(line, "=")).countTokens() <= 1 || !str.nextToken().trim().equals("system.ttp.id")) continue;
                fr.close();
                rd.close();
                return Integer.parseInt(str.nextToken().trim());
            }
            fr.close();
            rd.close();
            return -1;
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return -1;
        }
    }

    public void addServer(int id, String ip, int port) {
        this.controller.getStaticConf().addHostInfo(id, ip, port);
        this.rec.addServer(id, ip, port);
        this.addIds.add(id);
    }

    public void removeServer(int id) {
        this.rec.removeServer(id);
    }

    public void setF(int f) {
        this.rec.setF(f);
    }

    public void executeUpdates() {
        this.connect();
        ReconfigureReply r = this.rec.execute();
        View v = r.getView();
        System.out.println("New view f: " + v.getF());
        VMMessage msg = new VMMessage(this.id, r);
        if (this.addIds.size() > 0) {
            this.sendResponse(this.addIds.toArray(new Integer[1]), msg);
            this.addIds.clear();
        }
    }

    private ServerConnection getConnection(int remoteId) {
        return new ServerConnection(this.controller, null, remoteId, null, null);
    }

    public void sendResponse(Integer[] targets, VMMessage sm) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(bOut).writeObject(sm);
        }
        catch (IOException ex) {
            Logger.getLogger(ServerConnection.class.getName()).log(Level.SEVERE, null, ex);
        }
        byte[] data = bOut.toByteArray();
        for (Integer i : targets) {
            try {
                if (i == this.id) continue;
                this.getConnection(i).send(data, true);
            }
            catch (InterruptedException ex) {
                System.err.println(ex);
            }
        }
    }

    public void close() {
        this.rec.close();
    }

    public static void main(String[] args) {
        ViewManager viewManager = null;
        viewManager = args.length > 0 ? new ViewManager(args[0]) : new ViewManager("");
        Scanner scan = new Scanner(System.in);
        String str = null;
        do {
            str = scan.nextLine();
            String cmd = "";
            int arg = -1;
            try {
                StringTokenizer token = new StringTokenizer(str);
                cmd = token.nextToken();
                arg = Integer.parseInt(token.nextToken());
            }
            catch (Exception token) {
                // empty catch block
            }
            if (arg < 0) continue;
            if (cmd.equals("add")) {
                int port = arg * 10 + 11000;
                viewManager.addServer(arg, "127.0.0.1", port);
            } else if (cmd.equals("rem")) {
                viewManager.removeServer(arg);
            }
            viewManager.executeUpdates();
        } while (!str.equals("exit"));
        viewManager.close();
        System.exit(0);
    }
}

