/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class View
implements Serializable {
    private static final long serialVersionUID = 1466870385442069307L;
    private int id;
    private int f;
    private int[] processes;
    private Map<Integer, InetSocketAddress> addresses;

    public View(int id, int[] processes, int f, InetSocketAddress[] addresses) {
        this.id = id;
        this.processes = processes;
        this.addresses = new HashMap<Integer, InetSocketAddress>();
        for (int i = 0; i < this.processes.length; ++i) {
            this.addresses.put(processes[i], addresses[i]);
        }
        Arrays.sort(this.processes);
        this.f = f;
    }

    public boolean isMember(int id) {
        for (int i = 0; i < this.processes.length; ++i) {
            if (this.processes[i] != id) continue;
            return true;
        }
        return false;
    }

    public int getPos(int id) {
        for (int i = 0; i < this.processes.length; ++i) {
            if (this.processes[i] != id) continue;
            return i;
        }
        return -1;
    }

    public int getId() {
        return this.id;
    }

    public int getF() {
        return this.f;
    }

    public int getN() {
        return this.processes.length;
    }

    public int[] getProcesses() {
        return this.processes;
    }

    public String toString() {
        String ret = "ID:" + this.id + "; F:" + this.f + "; Processes:";
        for (int i = 0; i < this.processes.length; ++i) {
            ret = ret + this.processes[i] + "(" + this.addresses.get(this.processes[i]) + "),";
        }
        return ret;
    }

    public InetSocketAddress getAddress(int id) {
        return this.addresses.get(id);
    }
}

