/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.reconfiguration;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;

public class ReconfigureRequest
implements Externalizable {
    private int sender;
    private Hashtable<Integer, String> properties = new Hashtable();
    private byte[] signature;

    public ReconfigureRequest() {
    }

    public ReconfigureRequest(int sender) {
        this.sender = sender;
    }

    public void setSignature(byte[] signature) {
        this.signature = signature;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public Hashtable<Integer, String> getProperties() {
        return this.properties;
    }

    public int getSender() {
        return this.sender;
    }

    public void setProperty(int prop, String value) {
        this.properties.put(prop, value);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.sender);
        int num = this.properties.keySet().size();
        out.writeInt(num);
        for (int key : this.properties.keySet()) {
            String value = this.properties.get(key);
            out.writeInt(key);
            out.writeUTF(value);
        }
        out.writeInt(this.signature.length);
        out.write(this.signature);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sender = in.readInt();
        int num = in.readInt();
        for (int i = 0; i < num; ++i) {
            int key = in.readInt();
            String value = in.readUTF();
            this.properties.put(key, value);
        }
        this.signature = new byte[in.readInt()];
        in.read(this.signature);
    }

    public String toString() {
        String ret = "Sender :" + this.sender + ";";
        for (int key : this.properties.keySet()) {
            String value = this.properties.get(key);
            ret = ret + key + value;
        }
        return ret;
    }
}

