/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.random;

import bftsmart.tom.MessageContext;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.server.defaultservices.DefaultRecoverable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public final class RandomServer
extends DefaultRecoverable {
    private int value = 0;
    private int iterations = 0;
    private int id = -1;
    private ServiceReplica replica;

    public ServiceReplica getReplica() {
        return this.replica;
    }

    public void setReplica(ServiceReplica replica) {
        this.replica = replica;
    }

    public RandomServer(int id) {
        this.replica = new ServiceReplica(id, this, this);
        this.id = id;
    }

    public byte[] execute(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        try {
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(command));
            int operator = input.readInt();
            int argument = new BigInteger(msgCtx.getNonces()).intValue() + 1;
            System.out.println("(" + this.id + ")[server] Argument: " + argument);
            switch (operator) {
                case 0: {
                    this.value += argument;
                    System.out.println("(" + this.id + ")[server] Operator: +");
                    break;
                }
                case 1: {
                    this.value -= argument;
                    System.out.println("(" + this.id + ")[server] Operator: -");
                    break;
                }
                case 2: {
                    this.value *= argument;
                    System.out.println("(" + this.id + ")[server] Operator: *");
                    break;
                }
                case 3: {
                    this.value /= argument;
                    System.out.println("(" + this.id + ")[server] Operator: /");
                }
            }
            if (msgCtx == null) {
                System.out.println("Message Context is still null!!!???");
                System.exit(0);
            }
            System.out.println("(" + this.id + ")[server] (" + this.iterations + " / " + msgCtx.getConsensusId() + " / " + msgCtx.getRegency() + " / " + msgCtx.getLeader() + ") Current value: " + this.value);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4);
            new DataOutputStream(out).writeInt(this.value);
            return out.toByteArray();
        }
        catch (IOException ex) {
            System.err.println("Invalid request received!");
            return new byte[0];
        }
    }

    @Override
    public byte[] appExecuteUnordered(byte[] command, MessageContext msgCtx) {
        ++this.iterations;
        try {
            System.out.println("(" + this.id + ")[server] (" + this.iterations + " / " + msgCtx.getConsensusId() + ") Current value: " + this.value);
            ByteArrayOutputStream out = new ByteArrayOutputStream(4);
            new DataOutputStream(out).writeInt(this.value);
            return out.toByteArray();
        }
        catch (IOException ex) {
            System.err.println("Never happens!");
            return new byte[0];
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Use: java RandomServer <processId>");
            System.exit(-1);
        }
        new RandomServer(Integer.parseInt(args[0]));
    }

    public byte[] getState() {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(this.value >>> offset & 0xFF);
        }
        return b;
    }

    public void setState(byte[] state) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (state[i] & 0xFF) << shift;
        }
        this.value = value;
    }

    @Override
    public void installSnapshot(byte[] state) {
        int value = 0;
        for (int i = 0; i < 4; ++i) {
            int shift = (3 - i) * 8;
            value += (state[i] & 0xFF) << shift;
        }
        this.value = value;
    }

    @Override
    public byte[] getSnapshot() {
        byte[] b = new byte[4];
        for (int i = 0; i < 4; ++i) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(this.value >>> offset & 0xFF);
        }
        return b;
    }

    @Override
    public byte[][] appExecuteBatch(byte[][] commands, MessageContext[] msgCtxs) {
        byte[][] replies = new byte[commands.length][];
        for (int i = 0; i < commands.length; ++i) {
            replies[i] = this.execute(commands[i], msgCtxs[i]);
        }
        return replies;
    }
}

