/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.tom.ServiceProxy;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Storage;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ThroughputLatencyClient {
    public static int initId = 0;

    public static void main(String[] args) throws IOException {
        if (args.length < 8) {
            System.out.println("Usage: ... ThroughputLatencyClient <num. threads> <process id> <number of operations> <request size> <interval> <read only?> <verbose?> <DoS?>");
            System.exit(-1);
        }
        int numThreads = Integer.parseInt(args[0]);
        initId = Integer.parseInt(args[1]);
        int numberOfOps = Integer.parseInt(args[2]);
        int requestSize = Integer.parseInt(args[3]);
        int interval = Integer.parseInt(args[4]);
        boolean readOnly = Boolean.parseBoolean(args[5]);
        boolean verbose = Boolean.parseBoolean(args[6]);
        boolean dos = Boolean.parseBoolean(args[7]);
        Client[] clients = new Client[numThreads];
        for (int i = 0; i < numThreads; ++i) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ThroughputLatencyClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            System.out.println("Launching client " + (initId + i));
            clients[i] = new Client(initId + i, numberOfOps, requestSize, interval, readOnly, verbose, dos);
        }
        ExecutorService exec = Executors.newFixedThreadPool(clients.length);
        LinkedList tasks = new LinkedList();
        for (Client c : clients) {
            tasks.add(exec.submit(c));
        }
        for (Future future : tasks) {
            try {
                future.get();
            }
            catch (InterruptedException ex) {
                Logger.getLogger(ThroughputLatencyClient.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger(ThroughputLatencyClient.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        exec.shutdown();
        System.out.println("All clients done.");
    }

    static class Client
    extends Thread {
        int id;
        int numberOfOps;
        int requestSize;
        int interval;
        boolean readOnly;
        boolean verbose;
        boolean dos;
        ServiceProxy proxy;
        byte[] request;

        public Client(int id, int numberOfOps, int requestSize, int interval, boolean readOnly, boolean verbose, boolean dos) {
            super("Client " + id);
            this.id = id;
            this.numberOfOps = numberOfOps;
            this.requestSize = requestSize;
            this.interval = interval;
            this.readOnly = readOnly;
            this.verbose = verbose;
            this.proxy = new ServiceProxy(id);
            this.request = new byte[this.requestSize];
            this.dos = dos;
        }

        @Override
        public void run() {
            byte[] reply;
            int reqId;
            System.out.println("Warm up...");
            int req = 0;
            int i = 0;
            while (i < this.numberOfOps / 2) {
                if (this.verbose) {
                    System.out.print("Sending req " + req + "...");
                }
                if (this.dos) {
                    reqId = this.proxy.generateRequestId(this.readOnly ? TOMMessageType.UNORDERED_REQUEST : TOMMessageType.ORDERED_REQUEST);
                    this.proxy.TOMulticast(this.request, reqId, this.readOnly ? TOMMessageType.UNORDERED_REQUEST : TOMMessageType.ORDERED_REQUEST);
                } else {
                    reply = this.readOnly ? this.proxy.invokeUnordered(this.request) : this.proxy.invokeOrdered(this.request);
                }
                if (this.verbose) {
                    System.out.println(" sent!");
                }
                if (this.verbose && req % 1000 == 0) {
                    System.out.println(this.id + " // " + req + " operations sent!");
                }
                ++i;
                ++req;
            }
            Storage st = new Storage(this.numberOfOps / 2);
            System.out.println("Executing experiment for " + this.numberOfOps / 2 + " ops");
            int i2 = 0;
            while (i2 < this.numberOfOps / 2) {
                long last_send_instant = System.nanoTime();
                if (this.verbose) {
                    System.out.print(this.id + " // Sending req " + req + "...");
                }
                if (this.dos) {
                    reqId = this.proxy.generateRequestId(this.readOnly ? TOMMessageType.UNORDERED_REQUEST : TOMMessageType.ORDERED_REQUEST);
                    this.proxy.TOMulticast(this.request, reqId, this.readOnly ? TOMMessageType.UNORDERED_REQUEST : TOMMessageType.ORDERED_REQUEST);
                } else if (this.readOnly) {
                    reply = this.proxy.invokeUnordered(this.request);
                } else {
                    byte[] byArray = this.proxy.invokeOrdered(this.request);
                }
                if (this.verbose) {
                    System.out.println(this.id + " // sent!");
                }
                st.store(System.nanoTime() - last_send_instant);
                if (this.interval > 0) {
                    try {
                        Thread.sleep(this.interval);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.verbose && req % 1000 == 0) {
                    System.out.println(this.id + " // " + req + " operations sent!");
                }
                ++i2;
                ++req;
            }
            if (this.id == initId) {
                System.out.println(this.id + " // Average time for " + this.numberOfOps / 2 + " executions (-10%) = " + st.getAverage(true) / 1000L + " us ");
                System.out.println(this.id + " // Standard desviation for " + this.numberOfOps / 2 + " executions (-10%) = " + st.getDP(true) / 1000.0 + " us ");
                System.out.println(this.id + " // Average time for " + this.numberOfOps / 2 + " executions (all samples) = " + st.getAverage(false) / 1000L + " us ");
                System.out.println(this.id + " // Standard desviation for " + this.numberOfOps / 2 + " executions (all samples) = " + st.getDP(false) / 1000.0 + " us ");
                System.out.println(this.id + " // Maximum time for " + this.numberOfOps / 2 + " executions (all samples) = " + st.getMax(false) / 1000L + " us ");
            }
            this.proxy.close();
        }
    }
}

