/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.tom.ServiceProxy;
import bftsmart.tom.util.Storage;
import java.io.IOException;

public class LatencyClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 5) {
            System.out.println("Usage: java ...LatencyClient <process id> <number of operations> <request size> <interval> <read only?>");
            System.exit(-1);
        }
        try (ServiceProxy counterProxy = new ServiceProxy(Integer.parseInt(args[0]));){
            byte[] reply;
            int numberOfOps = Integer.parseInt(args[1]);
            int requestSize = Integer.parseInt(args[2]);
            int interval = Integer.parseInt(args[3]);
            boolean readOnly = Boolean.parseBoolean(args[4]);
            byte[] request = new byte[requestSize];
            System.out.println("Warm up...");
            for (int i = 0; i < numberOfOps / 2; ++i) {
                reply = readOnly ? counterProxy.invokeUnordered(request) : counterProxy.invokeOrdered(request);
            }
            Storage st = new Storage(numberOfOps / 2);
            System.out.println("Executing experiment for " + numberOfOps / 2 + " ops");
            for (int i = 0; i < numberOfOps / 2; ++i) {
                long last_send_instant = System.nanoTime();
                reply = readOnly ? counterProxy.invokeUnordered(request) : counterProxy.invokeOrdered(request);
                st.store(System.nanoTime() - last_send_instant);
                if (interval <= 0) continue;
                Thread.sleep(interval);
            }
            System.out.println("Average time for " + numberOfOps / 2 + " executions (-10%) = " + st.getAverage(true) / 1000L + " us ");
            System.out.println("Standard desviation for " + numberOfOps / 2 + " executions (-10%) = " + st.getDP(true) / 1000.0 + " us ");
            System.out.println("Average time for " + numberOfOps / 2 + " executions (all samples) = " + st.getAverage(false) / 1000L + " us ");
            System.out.println("Standard desviation for " + numberOfOps / 2 + " executions (all samples) = " + st.getDP(false) / 1000.0 + " us ");
            System.out.println("Maximum time for " + numberOfOps / 2 + " executions (all samples) = " + st.getMax(false) / 1000L + " us ");
        }
        System.exit(0);
    }
}

