/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.microbenchmarks;

import bftsmart.communication.client.ReplyListener;
import bftsmart.tom.AsynchServiceProxy;
import bftsmart.tom.RequestContext;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import java.io.IOException;
import java.util.Arrays;

public class AsyncLatencyClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 5) {
            System.out.println("Usage: java ...AsyncLatencyClient <process id> <number of operations> <request size> <interval in micro seconds> <read only?>");
            System.exit(-1);
        }
        try (final AsynchServiceProxy serviceProxy = new AsynchServiceProxy(Integer.parseInt(args[0]));){
            int numberOfOps = Integer.parseInt(args[1]);
            int requestSize = Integer.parseInt(args[2]);
            int interval = Integer.parseInt(args[3]);
            boolean readOnly = Boolean.parseBoolean(args[4]);
            byte[] request = new byte[requestSize];
            TOMMessageType reqType = readOnly ? TOMMessageType.UNORDERED_REQUEST : TOMMessageType.ORDERED_REQUEST;
            System.out.println("Executing experiment for " + numberOfOps + " ops");
            for (int i = 0; i < numberOfOps; ++i) {
                serviceProxy.invokeAsynchRequest(request, new ReplyListener(){
                    private int replies = 0;

                    @Override
                    public void replyReceived(RequestContext context, TOMMessage reply) {
                        StringBuilder builder = new StringBuilder();
                        builder.append("[RequestContext] id: " + context.getReqId() + " type: " + (Object)((Object)context.getRequestType()));
                        builder.append("[TOMMessage reply] sender id: " + reply.getSender() + " Hash content: " + Arrays.toString(reply.getContent()));
                        System.out.println(builder.toString());
                        ++this.replies;
                        if (this.replies >= context.getTargets().length) {
                            System.out.println("[RequestContext] clean request context id: " + context.getReqId());
                            serviceProxy.cleanAsynchRequest(context.getReqId());
                        }
                    }
                }, reqType);
                if (interval <= 0) continue;
                Thread.sleep(0L, interval);
            }
            Thread.sleep(100L);
        }
        System.out.println("Finished");
        System.exit(0);
    }
}

