/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.bftmap;

import bftsmart.demo.bftmap.BFTMap;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;

public class BFTMapClient {
    private static int VALUE_SIZE = 1024;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java BFTMapClient <process id>");
            System.exit(-1);
        }
        int idProcess = Integer.parseInt(args[0]);
        BFTMap bftMap = new BFTMap(idProcess);
        String tableName = "table";
        try {
            BFTMapClient.createTable(bftMap, tableName);
        }
        catch (Exception e1) {
            e1.printStackTrace();
            System.out.println("Problems: Inserting a new value into the table(" + tableName + "): " + e1.getLocalizedMessage());
            System.exit(1);
        }
        int ops = 0;
        while (true) {
            try {
                while (true) {
                    boolean result;
                    if (!(result = BFTMapClient.insertValue(bftMap, tableName, ops))) {
                        // empty if block
                    }
                    if (ops % 100 == 0) {
                        System.out.println("ops sent: " + ops);
                    }
                    ++ops;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private static boolean createTable(BFTMap bftMap, String nameTable) throws Exception {
        boolean tableExists = bftMap.containsKey(nameTable);
        System.out.println("tableExists:" + tableExists);
        if (!tableExists) {
            bftMap.put(nameTable, (Map<String, byte[]>)new TreeMap<String, byte[]>());
        }
        System.out.println("Created the table. Maybe");
        return tableExists;
    }

    private static boolean insertValue(BFTMap bftMap, String nameTable, int index) throws Exception {
        String key = "Key" + index;
        byte[] valueBytes = null;
        Random rand = new Random();
        valueBytes = new byte[VALUE_SIZE];
        rand.nextBytes(valueBytes);
        byte[] resultBytes = bftMap.putEntry(nameTable, key, valueBytes);
        return resultBytes != null;
    }
}

