/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.demo.bftmap;

import bftsmart.tom.ServiceProxy;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BFTMap
implements Map<String, Map<String, byte[]>> {
    ServiceProxy KVProxy = null;
    ByteArrayOutputStream out = null;

    public BFTMap(int id) {
        this.KVProxy = new ServiceProxy(id, "config");
    }

    public Map<String, byte[]> get(String tableName) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(5);
            dos.writeUTF(tableName);
            byte[] rep = this.KVProxy.invokeUnordered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            Map table = (Map)in.readObject();
            in.close();
            return table;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] getEntry(String tableName, String key) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(5);
            dos.writeUTF(tableName);
            dos.writeUTF(key);
            byte[] rep = this.KVProxy.invokeUnordered(this.out.toByteArray());
            return rep;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public Map<String, byte[]> put(String key, Map<String, byte[]> value) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(1);
            dos.writeUTF(key);
            ObjectOutputStream out1 = new ObjectOutputStream(this.out);
            out1.writeObject(value);
            out1.close();
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            Map table = (Map)in.readObject();
            in.close();
            return table;
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] putEntry(String tableName, String key, byte[] value) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(4);
            dos.writeUTF(tableName);
            dos.writeUTF(key);
            dos.writeUTF(new String(value));
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            return rep;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public Map<String, byte[]> remove(Object key) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(2);
            dos.writeUTF((String)key);
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            ByteArrayInputStream bis = new ByteArrayInputStream(rep);
            ObjectInputStream in = new ObjectInputStream(bis);
            Map table = (Map)in.readObject();
            in.close();
            return table;
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public byte[] removeEntry(String tableName, String key) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(7);
            dos.writeUTF(tableName);
            dos.writeUTF(key);
            byte[] rep = this.KVProxy.invokeOrdered(this.out.toByteArray());
            return rep;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public int size() {
        try {
            this.out = new ByteArrayOutputStream();
            new DataOutputStream(this.out).writeInt(3);
            byte[] rep = this.KVProxy.invokeUnordered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            int size = new DataInputStream(in).readInt();
            return size;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return -1;
        }
    }

    public int size1(String tableName) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(6);
            dos.writeUTF(tableName);
            byte[] rep = this.KVProxy.invokeUnordered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            int size = new DataInputStream(in).readInt();
            return size;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return 0;
        }
    }

    public boolean containsKey(String key) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(10);
            dos.writeUTF(key);
            byte[] rep = this.KVProxy.invokeUnordered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            boolean res = new DataInputStream(in).readBoolean();
            return res;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    public boolean containsKey1(String tableName, String key) {
        try {
            this.out = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(this.out);
            dos.writeInt(8);
            dos.writeUTF(tableName);
            dos.writeUTF(key);
            byte[] rep = this.KVProxy.invokeUnordered(this.out.toByteArray());
            ByteArrayInputStream in = new ByteArrayInputStream(rep);
            boolean res = new DataInputStream(in).readBoolean();
            return res;
        }
        catch (IOException ex) {
            Logger.getLogger(BFTMap.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void putAll(Map m) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set keySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Collection values() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Set entrySet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TreeMap<String, byte[]> get(Object key) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

