/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.consensus.roles;

import bftsmart.communication.ServerCommunicationSystem;
import bftsmart.consensus.Consensus;
import bftsmart.consensus.Epoch;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.consensus.messages.MessageFactory;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.ExecutionManager;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.core.messages.TOMMessageType;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public final class Acceptor {
    private int me;
    private ExecutionManager executionManager;
    private MessageFactory factory;
    private ServerCommunicationSystem communication;
    private TOMLayer tomLayer;
    private ServerViewController controller;
    private Mac mac;

    public Acceptor(ServerCommunicationSystem communication, MessageFactory factory, ServerViewController controller) {
        this.communication = communication;
        this.me = controller.getStaticConf().getProcessId();
        this.factory = factory;
        this.controller = controller;
        try {
            this.mac = Mac.getInstance("HmacMD5");
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    public MessageFactory getFactory() {
        return this.factory;
    }

    public void setExecutionManager(ExecutionManager manager) {
        this.executionManager = manager;
    }

    public void setTOMLayer(TOMLayer tom) {
        this.tomLayer = tom;
    }

    public final void deliver(ConsensusMessage msg) {
        if (this.executionManager.checkLimits(msg)) {
            Logger.println("processing paxos msg with id " + msg.getNumber());
            this.processMessage(msg);
        } else {
            Logger.println("out of context msg with id " + msg.getNumber());
            this.tomLayer.processOutOfContext();
        }
    }

    public final void processMessage(ConsensusMessage msg) {
        Consensus consensus = this.executionManager.getConsensus(msg.getNumber());
        consensus.lock.lock();
        Epoch epoch = consensus.getEpoch(msg.getEpoch(), this.controller);
        switch (msg.getType()) {
            case 44781: {
                this.proposeReceived(epoch, msg);
                break;
            }
            case 44782: {
                this.writeReceived(epoch, msg.getSender(), msg.getValue());
                break;
            }
            case 44783: {
                this.acceptReceived(epoch, msg);
            }
        }
        consensus.lock.unlock();
    }

    public void proposeReceived(Epoch epoch, ConsensusMessage msg) {
        int cid = epoch.getConsensus().getId();
        int ts = epoch.getConsensus().getEts();
        int ets = this.executionManager.getConsensus(msg.getNumber()).getEts();
        Logger.println("(Acceptor.proposeReceived) PROPOSE for consensus " + cid);
        if (msg.getSender() == this.executionManager.getCurrentLeader() && epoch.getTimestamp() == 0 && ts == ets && ets == 0) {
            this.executePropose(epoch, msg.getValue());
        } else {
            Logger.println("Propose received is not from the expected leader");
        }
    }

    private void executePropose(Epoch epoch, byte[] value) {
        int cid = epoch.getConsensus().getId();
        Logger.println("(Acceptor.executePropose) executing propose for " + cid + "," + epoch.getTimestamp());
        long consensusStartTime = System.nanoTime();
        if (epoch.propValue == null) {
            epoch.propValue = value;
            epoch.propValueHash = this.tomLayer.computeHash(value);
            epoch.getConsensus().addWritten(value);
            Logger.println("(Acceptor.executePropose) I have written value " + Arrays.toString(epoch.propValueHash) + " in consensus instance " + cid + " with timestamp " + epoch.getConsensus().getEts());
            if (cid == this.tomLayer.getLastExec() + 1) {
                this.tomLayer.setInExec(cid);
            }
            epoch.deserializedPropValue = this.tomLayer.checkProposedValue(value, true);
            if (epoch.deserializedPropValue != null && !epoch.isWriteSetted(this.me)) {
                if (epoch.getConsensus().getDecision().firstMessageProposed == null) {
                    epoch.getConsensus().getDecision().firstMessageProposed = epoch.deserializedPropValue[0];
                }
                if (epoch.getConsensus().getDecision().firstMessageProposed.consensusStartTime == 0L) {
                    epoch.getConsensus().getDecision().firstMessageProposed.consensusStartTime = consensusStartTime;
                }
                epoch.getConsensus().getDecision().firstMessageProposed.proposeReceivedTime = System.nanoTime();
                if (this.controller.getStaticConf().isBFT()) {
                    Logger.println("(Acceptor.executePropose) sending WRITE for " + cid);
                    epoch.setWrite(this.me, epoch.propValueHash);
                    epoch.getConsensus().getDecision().firstMessageProposed.writeSentTime = System.nanoTime();
                    this.communication.send(this.controller.getCurrentViewOtherAcceptors(), this.factory.createWrite(cid, epoch.getTimestamp(), epoch.propValueHash));
                    Logger.println("(Acceptor.executePropose) WRITE sent for " + cid);
                    this.computeWrite(cid, epoch, epoch.propValueHash);
                    Logger.println("(Acceptor.executePropose) WRITE computed for " + cid);
                } else {
                    epoch.setAccept(this.me, epoch.propValueHash);
                    epoch.getConsensus().getDecision().firstMessageProposed.writeSentTime = System.nanoTime();
                    epoch.getConsensus().getDecision().firstMessageProposed.acceptSentTime = System.nanoTime();
                    Logger.println("(Acceptor.executePropose) [CFT Mode] Setting consensus " + cid + " QuorumWrite tiemstamp to " + epoch.getConsensus().getEts() + " and value " + Arrays.toString(epoch.propValueHash));
                    epoch.getConsensus().setQuorumWrites(epoch.propValueHash);
                    this.communication.send(this.controller.getCurrentViewOtherAcceptors(), this.factory.createAccept(cid, epoch.getTimestamp(), epoch.propValueHash));
                    this.computeAccept(cid, epoch, epoch.propValueHash);
                }
                this.executionManager.processOutOfContext(epoch.getConsensus());
            }
        }
    }

    private void writeReceived(Epoch epoch, int a, byte[] value) {
        int cid = epoch.getConsensus().getId();
        Logger.println("(Acceptor.writeAcceptReceived) WRITE from " + a + " for consensus " + cid);
        epoch.setWrite(a, value);
        this.computeWrite(cid, epoch, value);
    }

    private void computeWrite(int cid, Epoch epoch, byte[] value) {
        int writeAccepted = epoch.countWrite(value);
        Logger.println("(Acceptor.computeWrite) I have " + writeAccepted + " WRITEs for " + cid + "," + epoch.getTimestamp());
        if (writeAccepted > this.controller.getQuorum() && Arrays.equals(value, epoch.propValueHash) && !epoch.isAcceptSetted(this.me)) {
            Logger.println("(Acceptor.computeWrite) sending WRITE for " + cid);
            Logger.println("(Acceptor.computeWrite) Setting consensus " + cid + " QuorumWrite tiemstamp to " + epoch.getConsensus().getEts() + " and value " + Arrays.toString(value));
            epoch.getConsensus().setQuorumWrites(value);
            epoch.setAccept(this.me, value);
            if (epoch.getConsensus().getDecision().firstMessageProposed != null) {
                epoch.getConsensus().getDecision().firstMessageProposed.acceptSentTime = System.nanoTime();
            }
            ConsensusMessage cm = this.factory.createAccept(cid, epoch.getTimestamp(), value);
            Logger.println("(Acceptor.computeWrite) Creating cryptographic proof for my ACCEPT message from consensus " + cid);
            this.insertProof(cm, epoch);
            int[] targets = this.controller.getCurrentViewOtherAcceptors();
            this.communication.getServersConn().send(targets, cm, true);
            epoch.addToProof(cm);
            this.computeAccept(cid, epoch, value);
        }
    }

    private void insertProof(ConsensusMessage cm, Epoch epoch) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
        try {
            new ObjectOutputStream(bOut).writeObject(cm);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        byte[] data = bOut.toByteArray();
        TOMMessage[] msgs = epoch.deserializedPropValue;
        boolean hasReconf = false;
        for (TOMMessage msg : msgs) {
            if (msg.getReqType() != TOMMessageType.RECONFIG || msg.getViewID() != this.controller.getCurrentViewId()) continue;
            hasReconf = true;
            break;
        }
        if (hasReconf) {
            PrivateKey RSAprivKey = this.controller.getStaticConf().getRSAPrivateKey();
            byte[] signature = TOMUtil.signMessage(RSAprivKey, data);
            cm.setProof(signature);
        } else {
            int[] processes = this.controller.getCurrentViewAcceptors();
            HashMap<Integer, byte[]> macVector = new HashMap<Integer, byte[]>();
            for (int id : processes) {
                try {
                    SecretKey key = null;
                    do {
                        if ((key = this.communication.getServersConn().getSecretKey(id)) != null) continue;
                        System.out.println("(Acceptor.insertProof) I don't have yet a secret key with " + id + ". Retrying.");
                        Thread.sleep(1000L);
                    } while (key == null);
                    this.mac.init(key);
                    macVector.put(id, this.mac.doFinal(data));
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                catch (InvalidKeyException ex) {
                    System.out.println("Problem with secret key from " + id);
                    ex.printStackTrace();
                }
            }
            cm.setProof(macVector);
        }
    }

    private void acceptReceived(Epoch epoch, ConsensusMessage msg) {
        int cid = epoch.getConsensus().getId();
        Logger.println("(Acceptor.acceptReceived) ACCEPT from " + msg.getSender() + " for consensus " + cid);
        epoch.setAccept(msg.getSender(), msg.getValue());
        epoch.addToProof(msg);
        this.computeAccept(cid, epoch, msg.getValue());
    }

    private void computeAccept(int cid, Epoch epoch, byte[] value) {
        Logger.println("(Acceptor.computeAccept) I have " + epoch.countAccept(value) + " ACCEPTs for " + cid + "," + epoch.getTimestamp());
        if (epoch.countAccept(value) > this.controller.getQuorum() && !epoch.getConsensus().isDecided()) {
            Logger.println("(Acceptor.computeAccept) Deciding " + cid);
            this.decide(epoch);
        }
    }

    private void decide(Epoch epoch) {
        if (epoch.getConsensus().getDecision().firstMessageProposed != null) {
            epoch.getConsensus().getDecision().firstMessageProposed.decisionTime = System.nanoTime();
        }
        epoch.getConsensus().decided(epoch, true);
    }
}

