/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.server;

import bftsmart.communication.SystemMessage;
import bftsmart.communication.server.ServersCommunicationLayer;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.reconfiguration.VMMessage;
import bftsmart.tom.ServiceReplica;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

public class ServerConnection {
    public static final String MAC_ALGORITHM = "HmacMD5";
    private static final long POOL_TIME = 5000L;
    private ServerViewController controller;
    private Socket socket;
    private DataOutputStream socketOutStream = null;
    private DataInputStream socketInStream = null;
    private int remoteId;
    private boolean useSenderThread;
    protected LinkedBlockingQueue<byte[]> outQueue;
    private HashSet<Integer> noMACs = null;
    private LinkedBlockingQueue<SystemMessage> inQueue;
    private SecretKey authKey = null;
    private Mac macSend;
    private Mac macReceive;
    private int macSize;
    private Lock connectLock = new ReentrantLock();
    private Lock sendLock;
    private boolean doWork = true;

    public ServerConnection(ServerViewController controller, Socket socket, int remoteId, LinkedBlockingQueue<SystemMessage> inQueue, ServiceReplica replica) {
        this.controller = controller;
        this.socket = socket;
        this.remoteId = remoteId;
        this.inQueue = inQueue;
        this.outQueue = new LinkedBlockingQueue(this.controller.getStaticConf().getOutQueueSize());
        this.noMACs = new HashSet();
        if (this.isToConnect()) {
            try {
                this.socket = new Socket(this.controller.getStaticConf().getHost(remoteId), this.controller.getStaticConf().getServerToServerPort(remoteId));
                ServersCommunicationLayer.setSocketOptions(this.socket);
                new DataOutputStream(this.socket.getOutputStream()).writeInt(this.controller.getStaticConf().getProcessId());
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.socket != null) {
            try {
                this.socketOutStream = new DataOutputStream(this.socket.getOutputStream());
                this.socketInStream = new DataInputStream(this.socket.getInputStream());
            }
            catch (IOException ex) {
                Logger.println("Error creating connection to " + remoteId);
                ex.printStackTrace();
            }
        }
        this.useSenderThread = this.controller.getStaticConf().isUseSenderThread();
        if (this.useSenderThread && this.controller.getStaticConf().getTTPId() != remoteId) {
            new SenderThread().start();
        } else {
            this.sendLock = new ReentrantLock();
        }
        this.authenticateAndEstablishAuthKey();
        if (!this.controller.getStaticConf().isTheTTP()) {
            if (this.controller.getStaticConf().getTTPId() == remoteId) {
                new TTPReceiverThread(replica).start();
            } else {
                new ReceiverThread().start();
            }
        }
    }

    public SecretKey getSecretKey() {
        return this.authKey;
    }

    public void shutdown() {
        Logger.println("SHUTDOWN for " + this.remoteId);
        this.doWork = false;
        this.closeSocket();
    }

    public final void send(byte[] data, boolean useMAC) throws InterruptedException {
        if (this.useSenderThread) {
            if (!useMAC) {
                Logger.println("(ServerConnection.send) Not sending defaultMAC " + System.identityHashCode(data));
                this.noMACs.add(System.identityHashCode(data));
            }
            if (!this.outQueue.offer(data)) {
                Logger.println("(ServerConnection.send) out queue for " + this.remoteId + " full (message discarded).");
            }
        } else {
            this.sendLock.lock();
            this.sendBytes(data, useMAC);
            this.sendLock.unlock();
        }
    }

    private final void sendBytes(byte[] messageData, boolean useMAC) {
        boolean abort = false;
        do {
            if (abort) {
                return;
            }
            if (this.socket != null && this.socketOutStream != null) {
                try {
                    byte[] mac = useMAC && this.controller.getStaticConf().getUseMACs() == 1 ? this.macSend.doFinal(messageData) : null;
                    byte[] data = new byte[5 + messageData.length + (mac != null ? mac.length : 0)];
                    int value = messageData.length;
                    System.arraycopy(new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value}, 0, data, 0, 4);
                    System.arraycopy(messageData, 0, data, 4, messageData.length);
                    if (mac != null) {
                        System.arraycopy(new byte[]{1}, 0, data, 4 + messageData.length, 1);
                        System.arraycopy(mac, 0, data, 5 + messageData.length, mac.length);
                    } else {
                        System.arraycopy(new byte[]{0}, 0, data, 4 + messageData.length, 1);
                    }
                    this.socketOutStream.write(data);
                    return;
                }
                catch (IOException ex) {
                    this.closeSocket();
                    this.waitAndConnect();
                    abort = true;
                }
            } else {
                this.waitAndConnect();
                abort = true;
            }
        } while (this.doWork);
    }

    private boolean isToConnect() {
        if (this.controller.getStaticConf().getTTPId() == this.remoteId) {
            return false;
        }
        if (this.controller.getStaticConf().getTTPId() == this.controller.getStaticConf().getProcessId()) {
            return true;
        }
        boolean ret = false;
        if (this.controller.isInCurrentView() && this.controller.getStaticConf().getProcessId() > this.remoteId) {
            ret = true;
        }
        return ret;
    }

    protected void reconnect(Socket newSocket) {
        this.connectLock.lock();
        if (this.socket == null || !this.socket.isConnected()) {
            try {
                if (this.isToConnect()) {
                    this.socket = new Socket(this.controller.getStaticConf().getHost(this.remoteId), this.controller.getStaticConf().getServerToServerPort(this.remoteId));
                    ServersCommunicationLayer.setSocketOptions(this.socket);
                    new DataOutputStream(this.socket.getOutputStream()).writeInt(this.controller.getStaticConf().getProcessId());
                } else {
                    this.socket = newSocket;
                }
            }
            catch (UnknownHostException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                System.out.println("Impossible to reconnect to replica " + this.remoteId);
            }
            if (this.socket != null) {
                try {
                    this.socketOutStream = new DataOutputStream(this.socket.getOutputStream());
                    this.socketInStream = new DataInputStream(this.socket.getInputStream());
                    this.authKey = null;
                    this.authenticateAndEstablishAuthKey();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        this.connectLock.unlock();
    }

    public void authenticateAndEstablishAuthKey() {
        if (this.authKey != null || this.socketOutStream == null || this.socketInStream == null) {
            return;
        }
        try {
            PrivateKey RSAprivKey = this.controller.getStaticConf().getRSAPrivateKey();
            BigInteger DHPrivKey = new BigInteger(RSAprivKey.getEncoded());
            BigInteger myDHPubKey = this.controller.getStaticConf().getDHG().modPow(DHPrivKey, this.controller.getStaticConf().getDHP());
            byte[] bytes = myDHPubKey.toByteArray();
            byte[] signature = TOMUtil.signMessage(RSAprivKey, bytes);
            this.socketOutStream.writeInt(bytes.length);
            this.socketOutStream.write(bytes);
            this.socketOutStream.writeInt(signature.length);
            this.socketOutStream.write(signature);
            int dataLength = this.socketInStream.readInt();
            bytes = new byte[dataLength];
            int read = 0;
            while ((read += this.socketInStream.read(bytes, read, dataLength - read)) < dataLength) {
            }
            byte[] remote_Bytes = bytes;
            dataLength = this.socketInStream.readInt();
            bytes = new byte[dataLength];
            read = 0;
            while ((read += this.socketInStream.read(bytes, read, dataLength - read)) < dataLength) {
            }
            byte[] remote_Signature = bytes;
            PublicKey remoteRSAPubkey = this.controller.getStaticConf().getRSAPublicKey(this.remoteId);
            if (!TOMUtil.verifySignature(remoteRSAPubkey, remote_Bytes, remote_Signature)) {
                System.out.println(this.remoteId + " sent an invalid signature!");
                this.shutdown();
                return;
            }
            BigInteger remoteDHPubKey = new BigInteger(remote_Bytes);
            BigInteger secretKey = remoteDHPubKey.modPow(DHPrivKey, this.controller.getStaticConf().getDHP());
            System.out.println("-- Diffie-Hellman complete with " + this.remoteId);
            SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            PBEKeySpec spec = new PBEKeySpec(secretKey.toString().toCharArray());
            this.authKey = fac.generateSecret(spec);
            this.macSend = Mac.getInstance(MAC_ALGORITHM);
            this.macSend.init(this.authKey);
            this.macReceive = Mac.getInstance(MAC_ALGORITHM);
            this.macReceive.init(this.authKey);
            this.macSize = this.macSend.getMacLength();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void closeSocket() {
        if (this.socket != null) {
            try {
                this.socketOutStream.flush();
                this.socket.close();
            }
            catch (IOException ex) {
                Logger.println("Error closing socket to " + this.remoteId);
            }
            catch (NullPointerException npe) {
                Logger.println("Socket already closed");
            }
            this.socket = null;
            this.socketOutStream = null;
            this.socketInStream = null;
        }
    }

    private void waitAndConnect() {
        if (this.doWork) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.outQueue.clear();
            this.reconnect(null);
        }
    }

    protected class TTPReceiverThread
    extends Thread {
        private ServiceReplica replica;

        public TTPReceiverThread(ServiceReplica replica) {
            super("TTPReceiver for " + ServerConnection.this.remoteId);
            this.replica = replica;
        }

        @Override
        public void run() {
            byte[] receivedMac = null;
            try {
                receivedMac = new byte[Mac.getInstance(ServerConnection.MAC_ALGORITHM).getMacLength()];
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                // empty catch block
            }
            while (ServerConnection.this.doWork) {
                if (ServerConnection.this.socket != null && ServerConnection.this.socketInStream != null) {
                    try {
                        int dataLength = ServerConnection.this.socketInStream.readInt();
                        byte[] data = new byte[dataLength];
                        int read = 0;
                        while ((read += ServerConnection.this.socketInStream.read(data, read, dataLength - read)) < dataLength) {
                        }
                        boolean result = true;
                        byte hasMAC = ServerConnection.this.socketInStream.readByte();
                        if (ServerConnection.this.controller.getStaticConf().getUseMACs() == 1 && hasMAC == 1) {
                            System.out.println("TTP CON USEMAC");
                            read = 0;
                            while ((read += ServerConnection.this.socketInStream.read(receivedMac, read, ServerConnection.this.macSize - read)) < ServerConnection.this.macSize) {
                            }
                            result = Arrays.equals(ServerConnection.this.macReceive.doFinal(data), receivedMac);
                        }
                        if (result) {
                            SystemMessage sm = (SystemMessage)new ObjectInputStream(new ByteArrayInputStream(data)).readObject();
                            if (sm.getSender() != ServerConnection.this.remoteId) continue;
                            this.replica.joinMsgReceived((VMMessage)sm);
                            continue;
                        }
                        Logger.println("WARNING: Violation of authentication in message received from " + ServerConnection.this.remoteId);
                    }
                    catch (ClassNotFoundException ex) {
                        ex.printStackTrace();
                    }
                    catch (IOException ex) {
                        if (!ServerConnection.this.doWork) continue;
                        ServerConnection.this.closeSocket();
                        ServerConnection.this.waitAndConnect();
                    }
                    continue;
                }
                ServerConnection.this.waitAndConnect();
            }
        }
    }

    protected class ReceiverThread
    extends Thread {
        public ReceiverThread() {
            super("Receiver for " + ServerConnection.this.remoteId);
        }

        @Override
        public void run() {
            byte[] receivedMac = null;
            try {
                receivedMac = new byte[Mac.getInstance(ServerConnection.MAC_ALGORITHM).getMacLength()];
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
            while (ServerConnection.this.doWork) {
                if (ServerConnection.this.socket != null && ServerConnection.this.socketInStream != null) {
                    try {
                        int dataLength = ServerConnection.this.socketInStream.readInt();
                        byte[] data = new byte[dataLength];
                        int read = 0;
                        while ((read += ServerConnection.this.socketInStream.read(data, read, dataLength - read)) < dataLength) {
                        }
                        boolean result = true;
                        byte hasMAC = ServerConnection.this.socketInStream.readByte();
                        if (ServerConnection.this.controller.getStaticConf().getUseMACs() == 1 && hasMAC == 1) {
                            read = 0;
                            while ((read += ServerConnection.this.socketInStream.read(receivedMac, read, ServerConnection.this.macSize - read)) < ServerConnection.this.macSize) {
                            }
                            result = Arrays.equals(ServerConnection.this.macReceive.doFinal(data), receivedMac);
                        }
                        if (result) {
                            SystemMessage sm = (SystemMessage)new ObjectInputStream(new ByteArrayInputStream(data)).readObject();
                            boolean bl = sm.authenticated = ServerConnection.this.controller.getStaticConf().getUseMACs() == 1 && hasMAC == 1;
                            if (sm.getSender() != ServerConnection.this.remoteId || ServerConnection.this.inQueue.offer(sm)) continue;
                            Logger.println("(ReceiverThread.run) in queue full (message from " + ServerConnection.this.remoteId + " discarded).");
                            System.out.println("(ReceiverThread.run) in queue full (message from " + ServerConnection.this.remoteId + " discarded).");
                            continue;
                        }
                        Logger.println("WARNING: Violation of authentication in message received from " + ServerConnection.this.remoteId);
                    }
                    catch (ClassNotFoundException dataLength) {
                    }
                    catch (IOException ex) {
                        if (!ServerConnection.this.doWork) continue;
                        Logger.println("Closing socket and reconnecting");
                        ServerConnection.this.closeSocket();
                        ServerConnection.this.waitAndConnect();
                    }
                    continue;
                }
                ServerConnection.this.waitAndConnect();
            }
        }
    }

    private class SenderThread
    extends Thread {
        public SenderThread() {
            super("Sender for " + ServerConnection.this.remoteId);
        }

        @Override
        public void run() {
            byte[] data = null;
            while (ServerConnection.this.doWork) {
                try {
                    data = ServerConnection.this.outQueue.poll(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (data == null) continue;
                int ref = System.identityHashCode(data);
                boolean sendMAC = !ServerConnection.this.noMACs.remove(ref);
                Logger.println("(ServerConnection.run) " + (sendMAC ? "Sending" : "Not sending") + " MAC for data " + ref);
                ServerConnection.this.sendBytes(data, sendMAC);
            }
            Logger.println("Sender for " + ServerConnection.this.remoteId + " stopped!");
        }
    }
}

