/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.tom.core.messages.TOMMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;

public class NettyTOMMessageEncoder
extends MessageToByteEncoder<TOMMessage> {
    private boolean isClient;
    private Map sessionTable;
    private int macLength;
    private int signatureLength;
    private ReentrantReadWriteLock rl;
    private boolean useMAC;

    public NettyTOMMessageEncoder(boolean isClient, Map sessionTable, int macLength, ReentrantReadWriteLock rl, int signatureLength, boolean useMAC) {
        this.isClient = isClient;
        this.sessionTable = sessionTable;
        this.macLength = macLength;
        this.rl = rl;
        this.signatureLength = signatureLength;
        this.useMAC = useMAC;
    }

    protected void encode(ChannelHandlerContext context, TOMMessage sm, ByteBuf buffer) throws Exception {
        byte[] macData = null;
        byte[] signatureData = null;
        byte[] msgData = sm.serializedMessage;
        if (sm.signed && (signatureData = sm.serializedMessageSignature).length != this.signatureLength) {
            System.out.println("WARNING: message signature has size " + signatureData.length + " and should have " + this.signatureLength);
        }
        if (this.useMAC && (macData = this.produceMAC(sm.destination, msgData, sm.getSender())) == null) {
            System.out.println("uses MAC and the MAC returned is null. Won't write to channel");
            return;
        }
        int dataLength = 1 + msgData.length + (macData == null ? 0 : macData.length) + (signatureData == null ? 0 : signatureData.length);
        buffer.writeInt(dataLength);
        buffer.writeByte(sm.signed ? 1 : 0);
        buffer.writeBytes(msgData);
        if (this.useMAC) {
            buffer.writeBytes(macData);
        }
        if (signatureData != null) {
            buffer.writeBytes(signatureData);
        }
        context.flush();
    }

    byte[] produceMAC(int id, byte[] data, int me) {
        NettyClientServerSession session = (NettyClientServerSession)this.sessionTable.get(id);
        if (session == null) {
            System.out.println("NettyTOMMessageEncoder.produceMAC(). session for client " + id + " is null");
            return null;
        }
        Mac macSend = session.getMacSend();
        return macSend.doFinal(data);
    }
}

