/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.reconfiguration.ViewController;
import bftsmart.tom.core.messages.TOMMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTOMMessageDecoder
extends ByteToMessageDecoder {
    private boolean isClient;
    private Map sessionTable;
    private int macSize;
    private int signatureSize;
    private ViewController controller;
    private boolean firstTime;
    private ReentrantReadWriteLock rl;
    private boolean useMAC;
    private Logger logger = LoggerFactory.getLogger(NettyTOMMessageDecoder.class);

    public NettyTOMMessageDecoder(boolean isClient, Map sessionTable, int macLength, ViewController controller, ReentrantReadWriteLock rl, int signatureLength, boolean useMAC) {
        this.isClient = isClient;
        this.sessionTable = sessionTable;
        this.macSize = macLength;
        this.controller = controller;
        this.firstTime = true;
        this.rl = rl;
        this.signatureSize = signatureLength;
        this.useMAC = useMAC;
        bftsmart.tom.util.Logger.println("new NettyTOMMessageDecoder!!, isClient=" + isClient);
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> list) throws Exception {
        if (buffer.readableBytes() < 4) {
            return;
        }
        int dataLength = buffer.getInt(buffer.readerIndex());
        if (buffer.readableBytes() < dataLength + 4) {
            return;
        }
        buffer.skipBytes(4);
        int totalLength = dataLength - 1;
        byte signed = buffer.readByte();
        int authLength = 0;
        if (signed == 1) {
            authLength += this.signatureSize;
        }
        if (this.useMAC) {
            authLength += this.macSize;
        }
        byte[] data = new byte[totalLength - authLength];
        buffer.readBytes(data);
        byte[] digest = null;
        if (this.useMAC) {
            digest = new byte[this.macSize];
            buffer.readBytes(digest);
        }
        byte[] signature = null;
        if (signed == 1) {
            signature = new byte[this.signatureSize];
            buffer.readBytes(signature);
        }
        DataInputStream dis = null;
        TOMMessage sm = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            dis = new DataInputStream(bais);
            sm = new TOMMessage();
            sm.rExternal(dis);
            sm.serializedMessage = data;
            if (signed == 1) {
                sm.serializedMessageSignature = signature;
                sm.signed = true;
            }
            if (this.useMAC) {
                sm.serializedMessageMAC = digest;
            }
            if (this.isClient) {
                if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                    System.out.println("MAC error: message discarded");
                    return;
                }
            } else {
                this.rl.readLock().lock();
                if (this.sessionTable.containsKey(sm.getSender())) {
                    this.rl.readLock().unlock();
                    if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                        bftsmart.tom.util.Logger.println("MAC error: message discarded");
                        return;
                    }
                } else {
                    bftsmart.tom.util.Logger.println("Creating MAC/public key stuff, first message from client" + sm.getSender());
                    bftsmart.tom.util.Logger.println("sessionTable size=" + this.sessionTable.size());
                    this.rl.readLock().unlock();
                    SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
                    String str = sm.getSender() + ":" + this.controller.getStaticConf().getProcessId();
                    PBEKeySpec spec = new PBEKeySpec(str.toCharArray());
                    SecretKey authKey = fac.generateSecret(spec);
                    Mac macSend = Mac.getInstance(this.controller.getStaticConf().getHmacAlgorithm());
                    macSend.init(authKey);
                    Mac macReceive = Mac.getInstance(this.controller.getStaticConf().getHmacAlgorithm());
                    macReceive.init(authKey);
                    NettyClientServerSession cs = new NettyClientServerSession(context.channel(), macSend, macReceive, sm.getSender());
                    this.rl.writeLock().lock();
                    this.sessionTable.put(sm.getSender(), cs);
                    bftsmart.tom.util.Logger.println("#active clients " + this.sessionTable.size());
                    this.rl.writeLock().unlock();
                    if (this.useMAC && !this.verifyMAC(sm.getSender(), data, digest)) {
                        bftsmart.tom.util.Logger.println("MAC error: message discarded");
                        return;
                    }
                }
            }
            bftsmart.tom.util.Logger.println("Decoded reply from " + sm.getSender() + " with sequence number " + sm.getSequence());
            list.add(sm);
        }
        catch (Exception ex) {
            bftsmart.tom.util.Logger.println("Impossible to decode message: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    boolean verifyMAC(int id, byte[] data, byte[] digest) {
        this.rl.readLock().lock();
        Mac macReceive = ((NettyClientServerSession)this.sessionTable.get(id)).getMacReceive();
        this.rl.readLock().unlock();
        boolean result = Arrays.equals(macReceive.doFinal(data), digest);
        return result;
    }
}

