/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.CommunicationSystemServerSide;
import bftsmart.communication.client.RequestReceiver;
import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.communication.client.netty.NettyServerPipelineFactory;
import bftsmart.reconfiguration.ServerViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.TOMUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import javax.crypto.Mac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class NettyClientServerCommunicationSystemServerSide
extends SimpleChannelInboundHandler<TOMMessage>
implements CommunicationSystemServerSide {
    private RequestReceiver requestReceiver;
    private HashMap sessionTable;
    private ReentrantReadWriteLock rl;
    private ServerViewController controller;
    private boolean closed = false;
    private Channel mainChannel;
    private NettyServerPipelineFactory serverPipelineFactory;
    private Logger logger = LoggerFactory.getLogger(NettyClientServerCommunicationSystemServerSide.class);

    public NettyClientServerCommunicationSystemServerSide(ServerViewController controller) {
        try {
            this.controller = controller;
            this.sessionTable = new HashMap();
            this.rl = new ReentrantReadWriteLock();
            Mac macDummy = Mac.getInstance(controller.getStaticConf().getHmacAlgorithm());
            this.serverPipelineFactory = new NettyServerPipelineFactory(this, this.sessionTable, macDummy.getMacLength(), controller, this.rl, TOMUtil.getSignatureSize(controller));
            NioEventLoopGroup bossGroup = new NioEventLoopGroup();
            int nWorkers = this.controller.getStaticConf().getNumNettyWorkers();
            NioEventLoopGroup workerGroup = nWorkers > 0 ? new NioEventLoopGroup(nWorkers) : new NioEventLoopGroup();
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{NettyClientServerCommunicationSystemServerSide.this.serverPipelineFactory.getDecoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{NettyClientServerCommunicationSystemServerSide.this.serverPipelineFactory.getEncoder()});
                    ch.pipeline().addLast(new ChannelHandler[]{NettyClientServerCommunicationSystemServerSide.this.serverPipelineFactory.getHandler()});
                }
            }).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childOption(ChannelOption.TCP_NODELAY, (Object)true);
            ChannelFuture f = b.bind((SocketAddress)new InetSocketAddress(controller.getStaticConf().getHost(controller.getStaticConf().getProcessId()), controller.getStaticConf().getPort(controller.getStaticConf().getProcessId()))).sync();
            System.out.println("-- ID = " + controller.getStaticConf().getProcessId());
            System.out.println("-- N = " + controller.getCurrentViewN());
            System.out.println("-- F = " + controller.getCurrentViewF());
            System.out.println("-- Port = " + controller.getStaticConf().getPort(controller.getStaticConf().getProcessId()));
            System.out.println("-- requestTimeout = " + controller.getStaticConf().getRequestTimeout());
            System.out.println("-- maxBatch = " + controller.getStaticConf().getMaxBatchSize());
            if (controller.getStaticConf().getUseMACs() == 1) {
                System.out.println("-- Using MACs");
            }
            if (controller.getStaticConf().getUseSignatures() == 1) {
                System.out.println("-- Using Signatures");
            }
            this.mainChannel = f.channel();
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    private void closeChannelAndEventLoop(Channel c) {
        c.flush();
        c.deregister();
        c.close();
        c.eventLoop().shutdownGracefully();
    }

    @Override
    public void shutdown() {
        System.out.println("Shutting down Netty system");
        this.closed = true;
        this.closeChannelAndEventLoop(this.mainChannel);
        this.rl.readLock().lock();
        ArrayList sessions = new ArrayList(this.sessionTable.values());
        this.rl.readLock().unlock();
        for (NettyClientServerSession ncss : sessions) {
            this.closeChannelAndEventLoop(ncss.getChannel());
        }
        java.util.logging.Logger.getLogger(NettyClientServerCommunicationSystemServerSide.class.getName()).log(Level.INFO, "NettyClientServerCommunicationSystemServerSide is halting.");
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        if (cause instanceof ClosedChannelException) {
            System.out.println("Connection with client closed.");
        } else if (cause instanceof ConnectException) {
            System.out.println("Impossible to connect to client.");
        } else {
            cause.printStackTrace(System.err);
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, TOMMessage sm) throws Exception {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        if (this.requestReceiver == null) {
            System.out.println("RECEIVER NULO!!!!!!!!!!!!");
        } else {
            this.requestReceiver.requestReceived(sm);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        bftsmart.tom.util.Logger.println("Session Created, active clients=" + this.sessionTable.size());
        System.out.println("Session Created, active clients=" + this.sessionTable.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        this.rl.writeLock().lock();
        try {
            Set s = this.sessionTable.entrySet();
            for (Map.Entry m : s) {
                NettyClientServerSession value = (NettyClientServerSession)m.getValue();
                if (!ctx.channel().equals(value.getChannel())) continue;
                int key = (Integer)m.getKey();
                System.out.println("#Removing client channel with ID= " + key);
                this.sessionTable.remove(key);
                System.out.println("#active clients=" + this.sessionTable.size());
                break;
            }
        }
        finally {
            this.rl.writeLock().unlock();
        }
        bftsmart.tom.util.Logger.println("Session Closed, active clients=" + this.sessionTable.size());
    }

    @Override
    public void setRequestReceiver(RequestReceiver tl) {
        this.requestReceiver = tl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(int[] targets, TOMMessage sm, boolean serializeClassHeaders) {
        FilterOutputStream dos = null;
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            sm.wExternal((DataOutput)((Object)dos));
            ((DataOutputStream)dos).flush();
            data = baos.toByteArray();
            sm.serializedMessage = data;
        }
        catch (IOException ex) {
            bftsmart.tom.util.Logger.println("Error enconding message.");
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException ex) {
                System.out.println("Exception closing DataOutputStream: " + ex.getMessage());
            }
        }
        sm.signed = false;
        if (sm.signed) {
            byte[] data2 = TOMUtil.signMessage(this.controller.getStaticConf().getRSAPrivateKey(), data);
            sm.serializedMessageSignature = data2;
        }
        for (int i = 0; i < targets.length; ++i) {
            this.rl.readLock().lock();
            try {
                NettyClientServerSession ncss = (NettyClientServerSession)this.sessionTable.get(targets[i]);
                if (ncss != null) {
                    Channel session = ncss.getChannel();
                    sm.destination = targets[i];
                    session.writeAndFlush((Object)sm);
                    continue;
                }
                if (sm.getSequence() >= 0 && sm.getSequence() <= 5) {
                    final int id = targets[i];
                    final TOMMessage msg = sm;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            System.out.println("Received request from " + id + " before establishing Netty connection. Re-trying until connection is established");
                            NettyClientServerSession ncss = null;
                            while (ncss == null) {
                                NettyClientServerCommunicationSystemServerSide.this.rl.readLock().lock();
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException ex) {
                                    java.util.logging.Logger.getLogger(NettyClientServerCommunicationSystemServerSide.class.getName()).log(Level.SEVERE, null, ex);
                                }
                                ncss = (NettyClientServerSession)NettyClientServerCommunicationSystemServerSide.this.sessionTable.get(id);
                                if (ncss != null) {
                                    Channel session = ncss.getChannel();
                                    msg.destination = id;
                                    session.writeAndFlush((Object)msg);
                                }
                                NettyClientServerCommunicationSystemServerSide.this.rl.readLock().unlock();
                            }
                            System.out.println("Connection with " + id + " established!");
                        }
                    };
                    t.start();
                    continue;
                }
                System.out.println("!!!!!!!!NettyClientServerSession NULL !!!!!! sequence: " + sm.getSequence() + ", ID; " + targets[i]);
                continue;
            }
            finally {
                this.rl.readLock().unlock();
            }
        }
    }
}

