/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.CommunicationSystemClientSide;
import bftsmart.communication.client.ReplyReceiver;
import bftsmart.communication.client.netty.NettyClientPipelineFactory;
import bftsmart.communication.client.netty.NettyClientServerSession;
import bftsmart.reconfiguration.ClientViewController;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.util.Logger;
import bftsmart.tom.util.TOMUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@ChannelHandler.Sharable
public class NettyClientServerCommunicationSystemClientSide
extends SimpleChannelInboundHandler<TOMMessage>
implements CommunicationSystemClientSide {
    private int clientId;
    protected ReplyReceiver trr;
    private ClientViewController controller;
    private Map<Integer, NettyClientServerSession> sessionTable = new HashMap<Integer, NettyClientServerSession>();
    private ReentrantReadWriteLock rl;
    private Signature signatureEngine;
    private int signatureLength;
    private boolean closed = false;
    private EventLoopGroup workerGroup;

    public NettyClientServerCommunicationSystemClientSide(int clientId, ClientViewController controller) {
        this.clientId = clientId;
        this.workerGroup = new NioEventLoopGroup();
        try {
            SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
            this.controller = controller;
            this.rl = new ReentrantReadWriteLock();
            this.signatureLength = TOMUtil.getSignatureSize(controller);
            ChannelFuture future = null;
            int[] currV = controller.getCurrentViewProcesses();
            for (int i = 0; i < currV.length; ++i) {
                try {
                    String str = this.clientId + ":" + currV[i];
                    PBEKeySpec spec = new PBEKeySpec(str.toCharArray());
                    SecretKey authKey = fac.generateSecret(spec);
                    Bootstrap b = new Bootstrap();
                    b.group(this.workerGroup);
                    b.channel(NioSocketChannel.class);
                    b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                    b.option(ChannelOption.TCP_NODELAY, (Object)true);
                    b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
                    b.handler((ChannelHandler)this.getChannelInitializer());
                    future = b.connect(controller.getRemoteAddress(currV[i]));
                    Mac macSend = Mac.getInstance(controller.getStaticConf().getHmacAlgorithm());
                    macSend.init(authKey);
                    Mac macReceive = Mac.getInstance(controller.getStaticConf().getHmacAlgorithm());
                    macReceive.init(authKey);
                    NettyClientServerSession cs = new NettyClientServerSession(future.channel(), macSend, macReceive, currV[i]);
                    this.sessionTable.put(currV[i], cs);
                    System.out.println("Connecting to replica " + currV[i] + " at " + controller.getRemoteAddress(currV[i]));
                    future.awaitUninterruptibly();
                    if (future.isSuccess()) continue;
                    System.err.println("Impossible to connect to " + currV[i]);
                    continue;
                }
                catch (NullPointerException ex) {
                    System.err.println("Should fix the problem, and I think it has no other implications :-), but we must make the servers store the view in a different place.");
                    continue;
                }
                catch (InvalidKeyException ex) {
                    ex.printStackTrace(System.err);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace(System.err);
        }
    }

    @Override
    public void updateConnections() {
        int[] currV = this.controller.getCurrentViewProcesses();
        try {
            for (int i = 0; i < currV.length; ++i) {
                this.rl.readLock().lock();
                if (this.sessionTable.get(currV[i]) == null) {
                    this.rl.readLock().unlock();
                    this.rl.writeLock().lock();
                    SecretKeyFactory fac = SecretKeyFactory.getInstance("PBEWithMD5AndDES");
                    try {
                        if (this.workerGroup == null) {
                            this.workerGroup = new NioEventLoopGroup();
                        }
                        Bootstrap b = new Bootstrap();
                        b.group(this.workerGroup);
                        b.channel(NioSocketChannel.class);
                        b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                        b.option(ChannelOption.TCP_NODELAY, (Object)true);
                        b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
                        b.handler((ChannelHandler)this.getChannelInitializer());
                        ChannelFuture future = b.connect(this.controller.getRemoteAddress(currV[i]));
                        String str = this.clientId + ":" + currV[i];
                        PBEKeySpec spec = new PBEKeySpec(str.toCharArray());
                        SecretKey authKey = fac.generateSecret(spec);
                        Mac macSend = Mac.getInstance(this.controller.getStaticConf().getHmacAlgorithm());
                        macSend.init(authKey);
                        Mac macReceive = Mac.getInstance(this.controller.getStaticConf().getHmacAlgorithm());
                        macReceive.init(authKey);
                        NettyClientServerSession cs = new NettyClientServerSession(future.channel(), macSend, macReceive, currV[i]);
                        this.sessionTable.put(currV[i], cs);
                        System.out.println("Connecting to replica " + currV[i] + " at " + this.controller.getRemoteAddress(currV[i]));
                        future.awaitUninterruptibly();
                        if (!future.isSuccess()) {
                            System.err.println("Impossible to connect to " + currV[i]);
                        }
                    }
                    catch (InvalidKeyException ex) {
                        ex.printStackTrace();
                    }
                    catch (InvalidKeySpecException ex) {
                        ex.printStackTrace();
                    }
                    this.rl.writeLock().unlock();
                    continue;
                }
                this.rl.readLock().unlock();
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof ClosedChannelException) {
            System.out.println("Connection with replica closed.");
        } else if (cause instanceof ConnectException) {
            System.out.println("Impossible to connect to replica.");
        } else {
            System.out.println("Replica disconnected.");
        }
        cause.printStackTrace();
    }

    public void channelRead0(ChannelHandlerContext ctx, TOMMessage sm) throws Exception {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        this.trr.replyReceived(sm);
    }

    public void channelActive(ChannelHandlerContext ctx) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        System.out.println("Channel active");
    }

    public void reconnect(ChannelHandlerContext ctx) {
        this.rl.writeLock().lock();
        Logger.println("try to reconnect");
        ArrayList<NettyClientServerSession> sessions = new ArrayList<NettyClientServerSession>(this.sessionTable.values());
        for (NettyClientServerSession ncss : sessions) {
            if (ncss.getChannel() != ctx.channel()) continue;
            try {
                if (this.workerGroup == null) {
                    this.workerGroup = new NioEventLoopGroup();
                }
                Bootstrap b = new Bootstrap();
                b.group(this.workerGroup);
                b.channel(NioSocketChannel.class);
                b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
                b.option(ChannelOption.TCP_NODELAY, (Object)true);
                b.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000);
                b.handler((ChannelHandler)this.getChannelInitializer());
                if (this.controller.getRemoteAddress(ncss.getReplicaId()) != null) {
                    ChannelFuture future = b.connect(this.controller.getRemoteAddress(ncss.getReplicaId()));
                    Mac macSend = ncss.getMacSend();
                    Mac macReceive = ncss.getMacReceive();
                    NettyClientServerSession cs = new NettyClientServerSession(future.channel(), macSend, macReceive, ncss.getReplicaId());
                    this.sessionTable.remove(ncss.getReplicaId());
                    this.sessionTable.put(ncss.getReplicaId(), cs);
                    System.out.println("re-connecting to replica " + ncss.getReplicaId() + " at " + this.controller.getRemoteAddress(ncss.getReplicaId()));
                    continue;
                }
                this.sessionTable.remove(ncss.getReplicaId());
            }
            catch (NoSuchAlgorithmException ex) {
                ex.printStackTrace();
            }
        }
        this.rl.writeLock().unlock();
    }

    @Override
    public void setReplyReceiver(ReplyReceiver trr) {
        this.trr = trr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(boolean sign, int[] targets, TOMMessage sm) {
        Logger.println("Sending request from " + sm.getSender() + " with sequence number " + sm.getSequence() + " to " + Arrays.toString(targets));
        if (sm.serializedMessage == null) {
            FilterOutputStream dos = null;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                dos = new DataOutputStream(baos);
                sm.wExternal((DataOutput)((Object)dos));
                ((DataOutputStream)dos).flush();
                sm.serializedMessage = baos.toByteArray();
            }
            catch (IOException ex) {
                Logger.println("Impossible to serialize message: " + sm);
            }
            finally {
                try {
                    dos.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (sign && sm.serializedMessageSignature == null) {
            sm.serializedMessageSignature = this.signMessage(this.controller.getStaticConf().getRSAPrivateKey(), sm.serializedMessage);
        }
        int sent = 0;
        for (int i = targets.length - 1; i >= 0; --i) {
            sm.destination = targets[i];
            this.rl.readLock().lock();
            Channel channel = this.sessionTable.get(targets[i]).getChannel();
            this.rl.readLock().unlock();
            if (channel.isActive()) {
                sm.signed = sign;
                channel.writeAndFlush((Object)sm);
                ++sent;
            } else {
                Logger.println("Channel to " + targets[i] + " is not connected");
            }
            try {
                sm = (TOMMessage)sm.clone();
                continue;
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
        }
        if (targets.length > this.controller.getCurrentViewF() && sent < this.controller.getCurrentViewF() + 1) {
            throw new RuntimeException("Impossible to connect to servers!");
        }
        if (targets.length == 1 && sent == 0) {
            throw new RuntimeException("Server not connected");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sign(TOMMessage sm) {
        FilterOutputStream dos = null;
        byte[] data = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            dos = new DataOutputStream(baos);
            sm.wExternal((DataOutput)((Object)dos));
            ((DataOutputStream)dos).flush();
            data = baos.toByteArray();
            sm.serializedMessage = data;
        }
        catch (IOException ex) {
        }
        finally {
            try {
                dos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        byte[] data2 = this.signMessage(this.controller.getStaticConf().getRSAPrivateKey(), data);
        sm.serializedMessageSignature = data2;
    }

    public byte[] signMessage(PrivateKey key, byte[] message) {
        try {
            if (this.signatureEngine == null) {
                this.signatureEngine = Signature.getInstance("SHA1withRSA");
            }
            byte[] result = null;
            this.signatureEngine.initSign(key);
            this.signatureEngine.update(message);
            result = this.signatureEngine.sign();
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void close() {
        this.closed = true;
        this.rl.readLock().lock();
        ArrayList<NettyClientServerSession> sessions = new ArrayList<NettyClientServerSession>(this.sessionTable.values());
        this.rl.readLock().unlock();
        for (NettyClientServerSession ncss : sessions) {
            Channel c = ncss.getChannel();
            this.closeChannelAndEventLoop(c);
        }
    }

    private ChannelInitializer getChannelInitializer() throws NoSuchAlgorithmException {
        Mac macDummy = Mac.getInstance(this.controller.getStaticConf().getHmacAlgorithm());
        final NettyClientPipelineFactory nettyClientPipelineFactory = new NettyClientPipelineFactory(this, this.sessionTable, macDummy.getMacLength(), this.controller, this.rl, this.signatureLength);
        ChannelInitializer<SocketChannel> channelInitializer = new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{nettyClientPipelineFactory.getDecoder()});
                ch.pipeline().addLast(new ChannelHandler[]{nettyClientPipelineFactory.getEncoder()});
                ch.pipeline().addLast(new ChannelHandler[]{nettyClientPipelineFactory.getHandler()});
            }
        };
        return channelInitializer;
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.scheduleReconnect(ctx, 10);
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.scheduleReconnect(ctx, 10);
    }

    private void closeChannelAndEventLoop(Channel c) {
        c.close();
        if (c.parent() != null) {
            c.parent().close();
        }
        this.workerGroup.shutdownGracefully();
    }

    private void scheduleReconnect(final ChannelHandlerContext ctx, int time) {
        if (this.closed) {
            this.closeChannelAndEventLoop(ctx.channel());
            return;
        }
        EventLoop loop = ctx.channel().eventLoop();
        loop.schedule(new Runnable(){

            @Override
            public void run() {
                NettyClientServerCommunicationSystemClientSide.this.reconnect(ctx);
            }
        }, (long)time, TimeUnit.SECONDS);
    }
}

