/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication.client.netty;

import bftsmart.communication.client.netty.NettyClientServerCommunicationSystemClientSide;
import bftsmart.communication.client.netty.NettyTOMMessageDecoder;
import bftsmart.communication.client.netty.NettyTOMMessageEncoder;
import bftsmart.reconfiguration.ClientViewController;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NettyClientPipelineFactory {
    NettyClientServerCommunicationSystemClientSide ncs;
    Map sessionTable;
    int macLength;
    int signatureLength;
    ClientViewController controller;
    ReentrantReadWriteLock rl;

    public NettyClientPipelineFactory(NettyClientServerCommunicationSystemClientSide ncs, Map sessionTable, int macLength, ClientViewController controller, ReentrantReadWriteLock rl, int signatureLength) {
        this.ncs = ncs;
        this.sessionTable = sessionTable;
        this.macLength = macLength;
        this.signatureLength = signatureLength;
        this.rl = rl;
        this.controller = controller;
    }

    public ByteToMessageDecoder getDecoder() {
        return new NettyTOMMessageDecoder(true, this.sessionTable, this.macLength, this.controller, this.rl, this.signatureLength, this.controller.getStaticConf().getUseMACs() == 1);
    }

    public MessageToByteEncoder getEncoder() {
        return new NettyTOMMessageEncoder(true, this.sessionTable, this.macLength, this.rl, this.signatureLength, this.controller.getStaticConf().getUseMACs() == 1);
    }

    public SimpleChannelInboundHandler getHandler() {
        return this.ncs;
    }
}

