/*
 * Decompiled with CFR 0.152.
 */
package bftsmart.communication;

import bftsmart.communication.SystemMessage;
import bftsmart.consensus.messages.ConsensusMessage;
import bftsmart.consensus.roles.Acceptor;
import bftsmart.statemanagement.SMMessage;
import bftsmart.tom.core.TOMLayer;
import bftsmart.tom.core.messages.ForwardedMessage;
import bftsmart.tom.core.messages.TOMMessage;
import bftsmart.tom.leaderchange.LCMessage;
import bftsmart.tom.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import javax.crypto.Mac;
import javax.crypto.SecretKey;

public class MessageHandler {
    private Acceptor acceptor;
    private TOMLayer tomLayer;
    private Mac mac;

    public MessageHandler() {
        try {
            this.mac = Mac.getInstance("HmacMD5");
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
        }
    }

    public void setAcceptor(Acceptor acceptor) {
        this.acceptor = acceptor;
    }

    public void setTOMLayer(TOMLayer tomLayer) {
        this.tomLayer = tomLayer;
    }

    protected void processData(SystemMessage sm) {
        if (sm instanceof ConsensusMessage) {
            int myId = this.tomLayer.controller.getStaticConf().getProcessId();
            ConsensusMessage consMsg = (ConsensusMessage)sm;
            if (this.tomLayer.controller.getStaticConf().getUseMACs() == 0 || consMsg.authenticated || consMsg.getSender() == myId) {
                this.acceptor.deliver(consMsg);
            } else if (consMsg.getType() == 44783 && consMsg.getProof() != null) {
                HashMap macVector = (HashMap)consMsg.getProof();
                byte[] recvMAC = (byte[])macVector.get(myId);
                ConsensusMessage cm = new ConsensusMessage(44783, consMsg.getNumber(), consMsg.getEpoch(), consMsg.getSender(), consMsg.getValue());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream(248);
                try {
                    new ObjectOutputStream(bOut).writeObject(cm);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                byte[] data = bOut.toByteArray();
                byte[] myMAC = null;
                SecretKey key = this.tomLayer.getCommunication().getServersConn().getSecretKey(consMsg.getSender());
                try {
                    this.mac.init(key);
                    myMAC = this.mac.doFinal(data);
                }
                catch (InvalidKeyException ex) {
                    ex.printStackTrace();
                }
                if (recvMAC != null && myMAC != null && Arrays.equals(recvMAC, myMAC)) {
                    this.acceptor.deliver(consMsg);
                } else {
                    Logger.println("(MessageHandler.processData) WARNING: invalid MAC from " + sm.getSender());
                    System.out.println("(MessageHandler.processData) WARNING: invalid MAC from " + sm.getSender());
                }
            } else {
                System.out.println("(MessageHandler.processData) Discarding unauthenticated message from " + sm.getSender());
                Logger.println("(MessageHandler.processData) Discarding unauthenticated message from " + sm.getSender());
            }
        } else if (this.tomLayer.controller.getStaticConf().getUseMACs() == 0 || sm.authenticated) {
            if (sm instanceof LCMessage) {
                LCMessage lcMsg = (LCMessage)sm;
                String type = null;
                switch (lcMsg.getType()) {
                    case 3: {
                        type = "STOP";
                        break;
                    }
                    case 4: {
                        type = "STOPDATA";
                        break;
                    }
                    case 5: {
                        type = "SYNC";
                        break;
                    }
                    default: {
                        type = "LOCAL";
                    }
                }
                System.out.println("(MessageHandler.processData) LC_MSG received: type " + type + ", regency " + lcMsg.getReg() + ", (replica " + lcMsg.getSender() + ")");
                if (lcMsg.TRIGGER_LC_LOCALLY) {
                    this.tomLayer.requestsTimer.run_lc_protocol();
                } else {
                    this.tomLayer.getSynchronizer().deliverTimeoutRequest(lcMsg);
                }
            } else if (sm instanceof ForwardedMessage) {
                TOMMessage request = ((ForwardedMessage)sm).getRequest();
                this.tomLayer.requestReceived(request);
            } else if (sm instanceof SMMessage) {
                SMMessage smsg = (SMMessage)sm;
                switch (smsg.getType()) {
                    case 6: {
                        this.tomLayer.getStateManager().SMRequestDeliver(smsg, this.tomLayer.controller.getStaticConf().isBFT());
                        break;
                    }
                    case 7: {
                        this.tomLayer.getStateManager().SMReplyDeliver(smsg, this.tomLayer.controller.getStaticConf().isBFT());
                        break;
                    }
                    case 11: {
                        this.tomLayer.getStateManager().currentConsensusIdAsked(smsg.getSender());
                        break;
                    }
                    case 12: {
                        this.tomLayer.getStateManager().currentConsensusIdReceived(smsg);
                        break;
                    }
                    default: {
                        this.tomLayer.getStateManager().stateTimeout();
                        break;
                    }
                }
            } else {
                System.out.println("UNKNOWN MESSAGE TYPE: " + sm);
            }
        } else {
            System.out.println("(MessageHandler.processData) Discarding unauthenticated message from " + sm.getSender());
        }
    }

    protected void verifyPending() {
        this.tomLayer.processOutOfContext();
    }
}

