/*
 * Decompiled with CFR 0.152.
 */
package com.github.bfsmith.geotimezone;

import com.github.bfsmith.geotimezone.TimeZoneResult;
import com.github.bfsmith.geotimezone.TimezoneFileReader;
import com.spatial4j.core.io.GeohashUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class TimeZoneLookup {
    private static final TimezoneFileReader tzFile = new TimezoneFileReader();
    private List<String> lookupData;

    public TimeZoneResult getTimeZone(double latitude, double longitude) {
        String geohash = GeohashUtils.encodeLatLon((double)latitude, (double)longitude, (int)5);
        List<Integer> lineNumber = this.getTzDataLineNumbers(geohash);
        List<String> timeZones = this.getTzsFromData(lineNumber);
        if (!timeZones.isEmpty()) {
            TimeZoneResult timeZoneResult = new TimeZoneResult(timeZones.get(0));
            for (int i = 1; i < timeZones.size(); ++i) {
                timeZoneResult.getAlternativeResults().add(timeZones.get(i));
            }
            return timeZoneResult;
        }
        int offsetHours = this.calculateOffsetHoursFromLongitude(longitude);
        return new TimeZoneResult(this.getTimeZoneId(offsetHours));
    }

    private List<Integer> getTzDataLineNumbers(String geohash) {
        String nextGeohash;
        String prevGeohash;
        int seeked = this.SeekTimeZoneFile(geohash);
        if (seeked <= 0) {
            return new ArrayList<Integer>();
        }
        int min = seeked;
        int max = seeked;
        String seekedGeohash = tzFile.getLine(seeked).substring(0, 5);
        while (seekedGeohash == (prevGeohash = tzFile.getLine(min - 1).substring(0, 5))) {
            --min;
        }
        while (seekedGeohash == (nextGeohash = tzFile.getLine(max + 1).substring(0, 5))) {
            ++max;
        }
        ArrayList<Integer> lineNumbers = new ArrayList<Integer>();
        for (int i = min; i <= max; ++i) {
            int lineNumber = Integer.parseInt(tzFile.getLine(i).substring(5));
            lineNumbers.add(lineNumber);
        }
        return lineNumbers;
    }

    private int SeekTimeZoneFile(String hash) {
        int min = 0;
        int max = tzFile.getCount();
        boolean converged = false;
        while (!converged) {
            int mid = (max - min) / 2 + min;
            String midLine = tzFile.getLine(mid);
            for (int i = 0; i < hash.length(); ++i) {
                if (midLine.charAt(i) == '-') {
                    return mid;
                }
                if (midLine.charAt(i) > hash.charAt(i)) {
                    max = mid == max ? min : mid;
                    break;
                }
                if (midLine.charAt(i) < hash.charAt(i)) {
                    min = mid == min ? max : mid;
                    break;
                }
                if (i == 4) {
                    return mid;
                }
                if (min != mid) continue;
                min = max;
                break;
            }
            if (min != max) continue;
            converged = true;
        }
        return -1;
    }

    private synchronized List<String> getLookupData() {
        if (this.lookupData == null) {
            try {
                String line;
                this.lookupData = new ArrayList<String>();
                ClassLoader classLoader = this.getClass().getClassLoader();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(classLoader.getResourceAsStream("TZL.dat")));
                while ((line = bufferedReader.readLine()) != null) {
                    this.lookupData.add(line);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return this.lookupData;
    }

    private List<String> getTzsFromData(List<Integer> lineNumbers) {
        List<String> lData = this.getLookupData();
        ArrayList<String> data = new ArrayList<String>();
        for (Integer lineNumber : lineNumbers) {
            String d = lData.get(lineNumber - 1);
            data.add(d);
        }
        return data;
    }

    private int calculateOffsetHoursFromLongitude(double longitude) {
        int dir = longitude < 0.0 ? -1 : 1;
        double posNo = Math.sqrt(Math.pow(longitude, 2.0));
        if (posNo <= 7.5) {
            return 0;
        }
        double offset = (posNo -= 7.5) / 15.0;
        if (posNo % 15.0 > 0.0) {
            offset += 1.0;
        }
        return dir * (int)Math.floor(offset);
    }

    private String getTimeZoneId(int offsetHours) {
        if (offsetHours == 0) {
            return "UTC";
        }
        String reversed = (offsetHours >= 0 ? "-" : "+") + Math.abs(offsetHours);
        return "Etc/GMT" + reversed;
    }
}

