/*
 * Decompiled with CFR 0.152.
 */
package care.better.platform.web.template;

import care.better.platform.web.template.converter.CompositionConverter;
import care.better.platform.web.template.provider.WebTemplateProvider;
import care.better.platform.web.template.validator.CompositionValidator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractWebTemplateTest {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private CompositionConverter compositionConverter;
    private WebTemplateProvider webTemplateProvider;
    private CompositionValidator compositionValidator;

    @BeforeEach
    public void setUp() {
    }

    @AfterEach
    public void tearDown() {
    }

    public CompositionConverter getCompositionConverter() {
        return this.compositionConverter;
    }

    public void setCompositionConverter(CompositionConverter compositionConverter) {
        this.compositionConverter = compositionConverter;
    }

    public WebTemplateProvider getWebTemplateProvider() {
        return this.webTemplateProvider;
    }

    public void setWebTemplateProvider(WebTemplateProvider webTemplateProvider) {
        this.webTemplateProvider = webTemplateProvider;
    }

    public CompositionValidator getCompositionValidator() {
        return this.compositionValidator;
    }

    public void setCompositionValidator(CompositionValidator compositionValidator) {
        this.compositionValidator = compositionValidator;
    }

    protected String getFileContent(String fileName) throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream(fileName);){
            if (inputStream == null) {
                throw new IllegalStateException(String.format("File with name %s was not found.", fileName));
            }
            String fileString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            if (fileName.endsWith(".json")) {
                this.objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
                fileString = this.objectMapper.writeValueAsString((Object)this.objectMapper.readTree(fileString));
            }
            String string = fileString;
            return string;
        }
    }

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

