/*
 * Decompiled with CFR 0.152.
 */
package de.beosign.snakeyamlanno.representer;

import de.beosign.snakeyamlanno.AnnotationAwarePropertyUtils;
import de.beosign.snakeyamlanno.property.YamlAnyGetter;
import de.beosign.snakeyamlanno.property.YamlProperty;
import de.beosign.snakeyamlanno.skip.SkipAtDumpPredicate;
import de.beosign.snakeyamlanno.skip.SkipIfEmpty;
import de.beosign.snakeyamlanno.skip.SkipIfNull;
import de.beosign.snakeyamlanno.util.NodeUtil;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public class AnnotationAwareRepresenter
extends Representer {
    public static final Comparator<Property> ORDER_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property property1, Property property2) {
            int order1 = 0;
            int order2 = 0;
            YamlProperty propertyAnnotation1 = (YamlProperty)property1.getAnnotation(YamlProperty.class);
            YamlProperty propertyAnnotation2 = (YamlProperty)property2.getAnnotation(YamlProperty.class);
            if (propertyAnnotation1 != null) {
                order1 = propertyAnnotation1.order();
            }
            if (propertyAnnotation2 != null) {
                order2 = propertyAnnotation2.order();
            }
            if (order2 != order1) {
                return order2 - order1;
            }
            return property1.compareTo(property2);
        }
    };
    private boolean skipEmpty;

    public AnnotationAwareRepresenter() {
        this(true);
    }

    public AnnotationAwareRepresenter(boolean skipEmpty) {
        this.setPropertyUtils(new AnnotationAwarePropertyUtils());
        this.skipEmpty = skipEmpty;
    }

    protected Set<Property> getProperties(Class<? extends Object> type) {
        Set propertySet = super.getProperties(type);
        TreeSet<Property> orderedProperties = new TreeSet<Property>(ORDER_COMPARATOR);
        orderedProperties.addAll(propertySet);
        return orderedProperties;
    }

    protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
        MappingNode mappingNode = super.representJavaBean(properties, javaBean);
        Property anyGetterProperty = properties.stream().filter(p -> p.getAnnotation(YamlAnyGetter.class) != null).findFirst().orElse(null);
        if (anyGetterProperty != null) {
            String name = anyGetterProperty.getName();
            NodeTuple anyGetterNodeTuple = null;
            for (NodeTuple nt : mappingNode.getValue()) {
                if (!name.equals(NodeUtil.getValue(nt.getKeyNode()))) continue;
                anyGetterNodeTuple = nt;
                break;
            }
            if (anyGetterNodeTuple != null) {
                mappingNode.getValue().remove(anyGetterNodeTuple);
                for (NodeTuple nt : ((MappingNode)anyGetterNodeTuple.getValueNode()).getValue()) {
                    mappingNode.getValue().add(nt);
                }
            }
        }
        return mappingNode;
    }

    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        if (this.skipEmpty && SkipIfEmpty.getInstance().skip(javaBean, property, propertyValue, customTag)) {
            return null;
        }
        if (this.skipEmpty && SkipIfNull.getInstance().skip(javaBean, property, propertyValue, customTag)) {
            return null;
        }
        YamlProperty propertyAnnotation = (YamlProperty)property.getAnnotation(YamlProperty.class);
        if (propertyAnnotation != null) {
            if (propertyAnnotation.skipAtDump()) {
                return null;
            }
            if (propertyAnnotation.skipAtDumpIf() != SkipAtDumpPredicate.class) {
                try {
                    SkipAtDumpPredicate skipAtDumpPredicate = propertyAnnotation.skipAtDumpIf().newInstance();
                    if (skipAtDumpPredicate.skip(javaBean, property, propertyValue, customTag)) {
                        return null;
                    }
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new YAMLException("Cannot create an instance of " + propertyAnnotation.skipAtDumpIf().getName(), (Throwable)e);
                }
            }
        }
        return super.representJavaBeanProperty(javaBean, property, propertyValue, customTag);
    }
}

