/*
 * Decompiled with CFR 0.152.
 */
package de.beosign.snakeyamlanno.constructor;

import de.beosign.snakeyamlanno.constructor.AnnotationAwareConstructor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class AnnotationAwareListConstructor
extends AnnotationAwareConstructor {
    private final Class<?> collectionItemType;

    public AnnotationAwareListConstructor(Class<?> collectionItemType) {
        super(List.class);
        Objects.requireNonNull(collectionItemType, "CollectionItemType parameter must not be null");
        this.collectionItemType = collectionItemType;
    }

    public AnnotationAwareListConstructor(Class<?> collectionItemType, boolean caseInsensitive) {
        super(List.class, caseInsensitive);
        Objects.requireNonNull(collectionItemType, "CollectionItemType parameter must not be null");
        this.collectionItemType = collectionItemType;
    }

    public Object getSingleData(Class<?> type) {
        if (Collection.class.isAssignableFrom(type)) {
            SequenceNode node = (SequenceNode)this.composer.getSingleNode();
            node.setTag(new Tag(type));
            for (Node n : node.getValue()) {
                n.setType(this.collectionItemType);
            }
            return this.constructDocument((Node)node);
        }
        return super.getSingleData(type);
    }
}

