/*
 * Decompiled with CFR 0.152.
 */
package de.beosign.snakeyamlanno.constructor;

import de.beosign.snakeyamlanno.AnnotationAwarePropertyUtils;
import de.beosign.snakeyamlanno.constructor.CustomConstructor;
import de.beosign.snakeyamlanno.constructor.DefaultCustomConstructor;
import de.beosign.snakeyamlanno.constructor.YamlConstructBy;
import de.beosign.snakeyamlanno.instantiator.CustomInstantiator;
import de.beosign.snakeyamlanno.instantiator.DefaultCustomInstantiator;
import de.beosign.snakeyamlanno.instantiator.DefaultGlobalInstantiator;
import de.beosign.snakeyamlanno.instantiator.DefaultInstantiator;
import de.beosign.snakeyamlanno.instantiator.GlobalCustomInstantiator;
import de.beosign.snakeyamlanno.instantiator.GlobalInstantiator;
import de.beosign.snakeyamlanno.instantiator.YamlInstantiateBy;
import de.beosign.snakeyamlanno.property.YamlProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class AnnotationAwareConstructor
extends Constructor {
    private Map<Class<?>, YamlConstructBy> constructByMap = new HashMap();
    private Map<Class<?>, YamlInstantiateBy> instantiateByMap = new HashMap();
    private IdentityHashMap<Node, Property> nodeToPropertyMap = new IdentityHashMap();
    private GlobalInstantiator globalInstantiator = new DefaultGlobalInstantiator();

    public AnnotationAwareConstructor(Class<?> theRoot) {
        this(theRoot, false);
    }

    public AnnotationAwareConstructor(Class<? extends Object> theRoot, boolean caseInsensitive) {
        super(theRoot);
        this.setPropertyUtils(new AnnotationAwarePropertyUtils(caseInsensitive));
        this.yamlClassConstructors.put(NodeId.mapping, new AnnotationAwareMappingConstructor());
        this.yamlClassConstructors.put(NodeId.scalar, new AnnotationAwareScalarConstructor());
    }

    public void setGlobalInstantiator(GlobalInstantiator globalInstantiator) {
        Objects.requireNonNull(globalInstantiator, "Global instantiator must not be set to null");
        this.globalInstantiator = globalInstantiator;
    }

    protected Object newInstance(Class<?> ancestor, Node node, boolean tryDefault) throws InstantiationException {
        DefaultInstantiator defaultInstantiator = (anc, n, tryDef) -> super.newInstance(anc, n, tryDef);
        YamlInstantiateBy instantiateBy = this.getInstantiateBy(node.getType());
        if (instantiateBy != null) {
            try {
                return instantiateBy.value().newInstance().createInstance(node, tryDefault, ancestor, defaultInstantiator, this.globalInstantiator);
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException("Cannot create instance using custom instantiator " + instantiateBy.value() + "for node " + node + " of type " + node.getType() + ": " + e.getMessage());
            }
        }
        return this.globalInstantiator.createInstance(node, tryDefault, ancestor, defaultInstantiator);
    }

    protected List<?> constructNodeAsList(Node node, Function<? super Node, ? extends Object> defaultConstructor) {
        Class origType = node.getType();
        Property propertyOfNode = this.nodeToPropertyMap.get(node);
        if (propertyOfNode.getActualTypeArguments() != null && propertyOfNode.getActualTypeArguments().length > 0) {
            node.setType(propertyOfNode.getActualTypeArguments()[0]);
        }
        Object singleObject = this.constructObject(node, defaultConstructor);
        node.setType(origType);
        if (singleObject == null) {
            return null;
        }
        return Collections.singletonList(singleObject);
    }

    public Map<Class<?>, YamlConstructBy> getConstructByMap() {
        return this.constructByMap;
    }

    public <T> void registerCustomConstructor(Class<T> forType, Class<? extends CustomConstructor<? extends T>> customConstructorClass) {
        this.constructByMap.put(forType, YamlConstructBy.Factory.of(customConstructorClass));
    }

    public void registerDefaultConstructor(Class<?> forType) {
        this.constructByMap.put(forType, YamlConstructBy.Factory.of(DefaultCustomConstructor.class));
    }

    public <T> void registerCustomInstantiator(Class<T> forType, Class<? extends CustomInstantiator<? extends T>> instantiator) {
        this.instantiateByMap.put(forType, YamlInstantiateBy.Factory.of(instantiator));
    }

    public void registerGlobalInstantiator(Class<?> forType) {
        this.instantiateByMap.put(forType, YamlInstantiateBy.Factory.of(GlobalCustomInstantiator.class));
    }

    public void registerDefaultInstantiator(Class<?> forType) {
        this.instantiateByMap.put(forType, YamlInstantiateBy.Factory.of(DefaultCustomInstantiator.class));
    }

    private <T> T constructObject(Node node, Function<? super Node, ? extends T> defaultConstructor) {
        YamlConstructBy constructBy = this.getConstructBy(node.getType());
        if (constructBy != null) {
            try {
                CustomConstructor<?> constructor = constructBy.value().newInstance();
                return constructor.construct(node, defaultConstructor);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new YAMLException("Cannot create custom constructor " + constructBy.value().getName(), (Throwable)e);
            }
        }
        return defaultConstructor.apply((Node)node);
    }

    protected YamlConstructBy getConstructBy(Class<?> type) {
        YamlConstructBy constructByFoundInMap = null;
        YamlConstructBy constructByAnnotation = null;
        ArrayList typesInHierarchy = new ArrayList();
        typesInHierarchy.add(type);
        typesInHierarchy.addAll(ClassUtils.getAllSuperclasses(type));
        typesInHierarchy.addAll(ClassUtils.getAllInterfaces(type));
        for (Class clazz : typesInHierarchy) {
            constructByFoundInMap = this.constructByMap.get(clazz);
            if (constructByFoundInMap != null) {
                return constructByFoundInMap;
            }
            constructByAnnotation = clazz.getDeclaredAnnotation(YamlConstructBy.class);
            if (constructByAnnotation == null) continue;
            return constructByAnnotation;
        }
        return null;
    }

    protected YamlInstantiateBy getInstantiateBy(Class<?> type) {
        return this.instantiateByMap.getOrDefault(type, type.getAnnotation(YamlInstantiateBy.class));
    }

    private static ScalarNode getKeyNode(NodeTuple tuple) {
        if (tuple.getKeyNode() instanceof ScalarNode) {
            return (ScalarNode)tuple.getKeyNode();
        }
        throw new YAMLException("Keys must be scalars but found: " + tuple.getKeyNode());
    }

    protected class AnnotationAwareScalarConstructor
    extends Constructor.ConstructScalar {
        protected AnnotationAwareScalarConstructor() {
            super((Constructor)AnnotationAwareConstructor.this);
        }

        public Object construct(Node node) {
            if (Collection.class.isAssignableFrom(node.getType())) {
                return AnnotationAwareConstructor.this.constructNodeAsList(node, x$0 -> super.construct(x$0));
            }
            return AnnotationAwareConstructor.this.constructObject(node, x$0 -> super.construct(x$0));
        }
    }

    protected class AnnotationAwareMappingConstructor
    extends Constructor.ConstructMapping {
        protected AnnotationAwareMappingConstructor() {
            super((Constructor)AnnotationAwareConstructor.this);
        }

        public Object construct(Node node) {
            if (Collection.class.isAssignableFrom(node.getType())) {
                return AnnotationAwareConstructor.this.constructNodeAsList(node, x$0 -> super.construct(x$0));
            }
            return AnnotationAwareConstructor.this.constructObject(node, x$0 -> super.construct(x$0));
        }

        protected Object constructJavaBean2ndStep(MappingNode node, Object object) {
            ArrayList<NodeTuple> nodeTuplesToBeRemoved = new ArrayList<NodeTuple>();
            Class beanType = node.getType();
            List nodeValue = node.getValue();
            for (NodeTuple tuple : nodeValue) {
                Construct constructor;
                ScalarNode keyNode = AnnotationAwareConstructor.getKeyNode(tuple);
                keyNode.setType(String.class);
                String key = (String)AnnotationAwareConstructor.this.constructObject((Node)keyNode);
                TypeDescription memberDescription = (TypeDescription)AnnotationAwareConstructor.this.typeDefinitions.get(beanType);
                Property property = memberDescription == null ? this.getProperty(beanType, key) : memberDescription.getProperty(key);
                Node valueNode = tuple.getValueNode();
                AnnotationAwareConstructor.this.nodeToPropertyMap.put(valueNode, property);
                if (property.getAnnotation(YamlConstructBy.class) != null) {
                    Object value = null;
                    try {
                        CustomConstructor<?> cc = ((YamlConstructBy)property.getAnnotation(YamlConstructBy.class)).value().newInstance();
                        constructor = AnnotationAwareConstructor.this.getConstructor(valueNode);
                        value = cc.construct(valueNode, arg_0 -> ((Construct)constructor).construct(arg_0));
                        property.set(object, value);
                        nodeTuplesToBeRemoved.add(tuple);
                        continue;
                    }
                    catch (YAMLException e) {
                        throw e;
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new YAMLException("Custom constructor " + ((YamlConstructBy)property.getAnnotation(YamlConstructBy.class)).value() + " on property " + object.getClass().getTypeName() + "::" + property + " cannot be created", (Throwable)e);
                    }
                    catch (Exception e) {
                        throw new YAMLException("Cannot set value of type " + (value != null ? value.getClass().getTypeName() : "null") + " into property " + object.getClass().getTypeName() + "::" + property, (Throwable)e);
                    }
                }
                YamlProperty propertyAnnotation = (YamlProperty)property.getAnnotation(YamlProperty.class);
                boolean ignoreExceptions = propertyAnnotation != null && propertyAnnotation.ignoreExceptions();
                if (!ignoreExceptions) continue;
                try {
                    constructor = AnnotationAwareConstructor.this.getConstructor(valueNode);
                    constructor.construct(valueNode);
                }
                catch (Exception e) {
                    nodeTuplesToBeRemoved.add(tuple);
                }
            }
            nodeTuplesToBeRemoved.forEach(nt -> node.getValue().remove(nt));
            return super.constructJavaBean2ndStep(node, object);
        }
    }
}

