/*
 * Decompiled with CFR 0.152.
 */
package de.beosign.snakeyamlanno;

import de.beosign.snakeyamlanno.convert.Converter;
import de.beosign.snakeyamlanno.property.AliasedProperty;
import de.beosign.snakeyamlanno.property.AnnotatedProperty;
import de.beosign.snakeyamlanno.property.AnySetterProperty;
import de.beosign.snakeyamlanno.property.ConvertedProperty;
import de.beosign.snakeyamlanno.property.SkippedProperty;
import de.beosign.snakeyamlanno.property.YamlAnyGetter;
import de.beosign.snakeyamlanno.property.YamlAnySetter;
import de.beosign.snakeyamlanno.property.YamlProperty;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.ClassUtils;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;

public class AnnotationAwarePropertyUtils
extends PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> typeToPropertiesMap = new HashMap();
    private final Map<Class<?>, Method> typeToAnySetterMap = new HashMap();
    private final boolean caseInsensitive;

    public AnnotationAwarePropertyUtils() {
        this(false);
    }

    public AnnotationAwarePropertyUtils(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    protected Map<String, Property> getPropertiesMap(Class<?> type, BeanAccess bAccess) {
        if (this.typeToPropertiesMap.containsKey(type)) {
            return this.typeToPropertiesMap.get(type);
        }
        Map properties = super.getPropertiesMap(type, bAccess);
        LinkedHashMap<String, Property> replacedMap = new LinkedHashMap();
        for (String name : properties.keySet()) {
            if (((Property)properties.get(name)).getAnnotation(YamlAnyGetter.class) != null && !Map.class.isAssignableFrom(((Property)properties.get(name)).getType())) {
                throw new YAMLException(YamlAnyGetter.class.getSimpleName() + " may only be placed on properties of type " + Map.class.getName());
            }
            try {
                ReplacementResult replacementResult = this.getReplacement((Property)properties.get(name));
                replacedMap.put(replacementResult.getName(), replacementResult.getProperty());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new YAMLException("Error while calculating a replacement property for property " + type.getTypeName() + "." + properties.get(name), (Throwable)e);
            }
        }
        if (this.caseInsensitive) {
            replacedMap = AnnotationAwarePropertyUtils.toCaseInsensitiveMap(replacedMap);
        }
        this.typeToPropertiesMap.put(type, replacedMap);
        return replacedMap;
    }

    public Property getProperty(Class<? extends Object> type, String name, BeanAccess bAccess) {
        try {
            return super.getProperty(type, name, bAccess);
        }
        catch (YAMLException e) {
            Method anySetterMethod = this.typeToAnySetterMap.get(type);
            if (anySetterMethod == null) {
                ArrayList<Class<? extends Object>> typesInHierarchy = new ArrayList<Class<? extends Object>>();
                typesInHierarchy.add(type);
                typesInHierarchy.addAll(ClassUtils.getAllSuperclasses(type));
                typesInHierarchy.addAll(ClassUtils.getAllInterfaces(type));
                anySetterMethod = typesInHierarchy.stream().flatMap(t -> Arrays.stream(t.getDeclaredMethods())).filter(m -> Modifier.isPublic(m.getModifiers())).filter(m -> m.isAnnotationPresent(YamlAnySetter.class)).findFirst().orElse(null);
            }
            if (anySetterMethod != null) {
                this.typeToAnySetterMap.put(type, anySetterMethod);
                return new AnySetterProperty(name, anySetterMethod);
            }
            throw e;
        }
    }

    private ReplacementResult getReplacement(Property defaultProperty) throws InstantiationException, IllegalAccessException {
        Property replacementProperty = defaultProperty;
        String replacementName = defaultProperty.getName();
        YamlProperty propertyAnnotation = (YamlProperty)defaultProperty.getAnnotation(YamlProperty.class);
        if (propertyAnnotation != null) {
            if (propertyAnnotation.converter() != Converter.NoConverter.class) {
                replacementProperty = new ConvertedProperty(replacementProperty, propertyAnnotation.converter());
            }
            if (!propertyAnnotation.key().equals("")) {
                replacementName = propertyAnnotation.key();
                replacementProperty = new AliasedProperty(replacementProperty, replacementName);
            }
            if (propertyAnnotation.skipAtLoad()) {
                replacementProperty = new SkippedProperty(replacementProperty);
            }
            if (!(replacementProperty instanceof AnnotatedProperty)) {
                replacementProperty = new AnnotatedProperty(replacementProperty);
            }
        }
        return new ReplacementResult(replacementName, replacementProperty);
    }

    private static <T> Map<String, T> caseInsensitiveMap() {
        return new TreeMap(String.CASE_INSENSITIVE_ORDER);
    }

    private static <T> Map<String, T> toCaseInsensitiveMap(Map<String, T> map) {
        Map<String, T> caseInsensitiveMap = AnnotationAwarePropertyUtils.caseInsensitiveMap();
        caseInsensitiveMap.putAll(map);
        return caseInsensitiveMap;
    }

    private static final class ReplacementResult {
        private final Property property;
        private final String name;

        private ReplacementResult(String name, Property property) {
            this.name = name;
            this.property = property;
        }

        public String getName() {
            return this.name;
        }

        public Property getProperty() {
            return this.property;
        }
    }
}

