/*
 * Decompiled with CFR 0.152.
 */
package de.beosign.snakeyamlanno.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;

public final class NodeUtil {
    private NodeUtil() {
    }

    public static Map<String, Node> getPropertyToValueNodeMap(MappingNode mappingNode) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        for (NodeTuple nt : mappingNode.getValue()) {
            ScalarNode sn = (ScalarNode)nt.getKeyNode();
            map.put(sn.getValue(), nt.getValueNode());
        }
        return map;
    }

    public static Map<String, Object> getPropertyToValueMap(MappingNode mappingNode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (NodeTuple nt : mappingNode.getValue()) {
            ScalarNode sn = (ScalarNode)nt.getKeyNode();
            map.put(sn.getValue(), NodeUtil.getValue(nt.getValueNode()));
        }
        return map;
    }

    public static Object getValue(Node node) {
        if (node instanceof ScalarNode) {
            return ((ScalarNode)node).getValue();
        }
        if (node instanceof MappingNode) {
            return NodeUtil.getPropertyToValueMap((MappingNode)node);
        }
        if (node instanceof SequenceNode) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Node n : ((SequenceNode)node).getValue()) {
                values.add(NodeUtil.getValue(n));
            }
            return values;
        }
        throw new IllegalArgumentException("Unknown node type: " + node.getClass());
    }

    public static boolean removeNode(MappingNode mappingNode, String key) {
        return mappingNode.getValue().removeIf(nt -> NodeUtil.getValue(nt.getKeyNode()).equals(key));
    }
}

