/*
 * Decompiled with CFR 0.152.
 */
package de.beosign.snakeyamlanno.property;

import de.beosign.snakeyamlanno.property.AnnotatedProperty;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;

public class AnySetterProperty
extends AnnotatedProperty {
    private final Method anySetterMethod;

    public AnySetterProperty(String name, Method anySetterMethod) {
        super(name, (Property)new MissingProperty(name));
        Supplier<String> messageSupplier = () -> "Method " + anySetterMethod.getName() + " is expected to have two parameters, String and Object, but found: " + Arrays.stream(anySetterMethod.getParameterTypes()).map(c -> c.getName()).collect(Collectors.joining(", "));
        if (anySetterMethod.getParameterCount() != 2) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
        if (!anySetterMethod.getParameterTypes()[0].equals(String.class) || !anySetterMethod.getParameterTypes()[1].equals(Object.class)) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
        this.anySetterMethod = anySetterMethod;
    }

    @Override
    public void set(Object object, Object value) throws Exception {
        this.anySetterMethod.invoke(object, this.getName(), value);
    }
}

