/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.reporter;

import com.github.benmanes.gradle.versions.reporter.AbstractReporter;
import com.github.benmanes.gradle.versions.reporter.AbstractReporterKt;
import com.github.benmanes.gradle.versions.reporter.result.Result;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0005H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/github/benmanes/gradle/versions/reporter/JsonReporter;", "Lcom/github/benmanes/gradle/versions/reporter/AbstractReporter;", "project", "Lorg/gradle/api/Project;", "revision", "", "gradleReleaseChannel", "<init>", "(Lorg/gradle/api/Project;Ljava/lang/String;Ljava/lang/String;)V", "getProject", "()Lorg/gradle/api/Project;", "getRevision", "()Ljava/lang/String;", "getGradleReleaseChannel", "write", "", "printStream", "Ljava/io/OutputStream;", "result", "Lcom/github/benmanes/gradle/versions/reporter/result/Result;", "getFileExtension", "Companion", "gradle-versions-plugin"})
public final class JsonReporter
extends AbstractReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String revision;
    @NotNull
    private final String gradleReleaseChannel;
    private static final Moshi moshi = new Moshi.Builder().addLast((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build();

    public JsonReporter(@NotNull Project project, @NotNull String revision, @NotNull String gradleReleaseChannel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)gradleReleaseChannel, (String)"gradleReleaseChannel");
        super(project, revision, gradleReleaseChannel);
        this.project = project;
        this.revision = revision;
        this.gradleReleaseChannel = gradleReleaseChannel;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getRevision() {
        return this.revision;
    }

    @Override
    @NotNull
    public String getGradleReleaseChannel() {
        return this.gradleReleaseChannel;
    }

    @Override
    public void write(@NotNull OutputStream printStream, @NotNull Result result) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        JsonAdapter jsonAdapter = moshi.adapter(Result.class).serializeNulls().indent(" ");
        String string = jsonAdapter.toJson((Object)result);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
        String json = StringsKt.trimMargin$default((String)string, null, (int)1, null);
        AbstractReporterKt.println(printStream, json);
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "json";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/benmanes/gradle/versions/reporter/JsonReporter$Companion;", "", "<init>", "()V", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "Lcom/squareup/moshi/Moshi;", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

