/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.reporter;

import com.github.benmanes.gradle.versions.reporter.AbstractReporter;
import com.github.benmanes.gradle.versions.reporter.result.Dependency;
import com.github.benmanes.gradle.versions.reporter.result.DependencyLatest;
import com.github.benmanes.gradle.versions.reporter.result.DependencyOutdated;
import com.github.benmanes.gradle.versions.reporter.result.DependencyUnresolved;
import com.github.benmanes.gradle.versions.reporter.result.Result;
import com.github.benmanes.gradle.versions.reporter.result.VersionAvailable;
import com.github.benmanes.gradle.versions.updates.gradle.GradleUpdateResult;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J*\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J(\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!H\u0002J \u0010\"\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J \u0010#\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J(\u0010$\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J \u0010(\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J \u0010)\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J \u0010*\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010+\u001a\u00020\u00122\u0006\u0010,\u001a\u00020-H\u0002R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006."}, d2={"Lcom/github/benmanes/gradle/versions/reporter/XmlReporter;", "Lcom/github/benmanes/gradle/versions/reporter/AbstractReporter;", "project", "Lorg/gradle/api/Project;", "revision", "", "gradleReleaseChannel", "(Lorg/gradle/api/Project;Ljava/lang/String;Ljava/lang/String;)V", "getGradleReleaseChannel", "()Ljava/lang/String;", "getProject", "()Lorg/gradle/api/Project;", "getRevision", "appendTextChild", "", "document", "Lorg/w3c/dom/Document;", "parent", "Lorg/w3c/dom/Element;", "name", "textContent", "", "getFileExtension", "write", "printStream", "Ljava/io/OutputStream;", "result", "Lcom/github/benmanes/gradle/versions/reporter/result/Result;", "writeCurrentSection", "response", "writeDependency", "element", "dependency", "Lcom/github/benmanes/gradle/versions/reporter/result/Dependency;", "writeExceededSection", "writeGradle", "writeGradleUpdate", "update", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateResult;", "writeOutdatedSection", "writeUndeclaredSection", "writeUnresolvedSection", "writeVersionAvailable", "dependencyElement", "version", "Lcom/github/benmanes/gradle/versions/reporter/result/VersionAvailable;", "gradle-versions-plugin"})
public final class XmlReporter
extends AbstractReporter {
    @NotNull
    private final Project project;
    @NotNull
    private final String revision;
    @NotNull
    private final String gradleReleaseChannel;

    public XmlReporter(@NotNull Project project, @NotNull String revision, @NotNull String gradleReleaseChannel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)gradleReleaseChannel, (String)"gradleReleaseChannel");
        super(project, revision, gradleReleaseChannel);
        this.project = project;
        this.revision = revision;
        this.gradleReleaseChannel = gradleReleaseChannel;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getRevision() {
        return this.revision;
    }

    @Override
    @NotNull
    public String getGradleReleaseChannel() {
        return this.gradleReleaseChannel;
    }

    @Override
    public void write(@NotNull OutputStream printStream, @NotNull Result result) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        document.setXmlStandalone(true);
        Element response = document.createElement("response");
        document.appendChild(response);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"document");
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        this.appendTextChild(document, response, "count", result.getCount());
        this.writeCurrentSection(result, document, response);
        this.writeOutdatedSection(result, document, response);
        this.writeExceededSection(result, document, response);
        this.writeUndeclaredSection(result, document, response);
        this.writeUnresolvedSection(result, document, response);
        this.writeGradle(result, document, response);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        transformerFactory.setAttribute("indent-number", 2);
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("standalone", "yes");
        DOMSource source = new DOMSource(document);
        StreamResult resultStream = new StreamResult(printStream);
        transformer.transform(source, resultStream);
    }

    private final void writeCurrentSection(Result result, Document document, Element response) {
        Element current = document.createElement("current");
        response.appendChild(current);
        Intrinsics.checkNotNullExpressionValue((Object)current, (String)"current");
        this.appendTextChild(document, current, "count", result.getCurrent().getCount());
        Element dependencies = document.createElement("dependencies");
        current.appendChild(dependencies);
        for (Dependency dependency : result.getCurrent().getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)dependencies, (String)"dependencies");
            this.writeDependency(document, dependencies, "dependency", dependency);
        }
    }

    private final void writeOutdatedSection(Result result, Document document, Element response) {
        Element outdated = document.createElement("outdated");
        response.appendChild(outdated);
        Intrinsics.checkNotNullExpressionValue((Object)outdated, (String)"outdated");
        this.appendTextChild(document, outdated, "count", result.getOutdated().getCount());
        Element dependencies = document.createElement("dependencies");
        outdated.appendChild(dependencies);
        for (DependencyOutdated dependency : result.getOutdated().getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)dependencies, (String)"dependencies");
            Element element = this.writeDependency(document, dependencies, "outdatedDependency", dependency);
            this.writeVersionAvailable(document, element, dependency.getAvailable());
        }
    }

    private final void writeVersionAvailable(Document document, Element dependencyElement, VersionAvailable version) {
        Element available = document.createElement("available");
        dependencyElement.appendChild(available);
        Intrinsics.checkNotNullExpressionValue((Object)available, (String)"available");
        this.appendTextChild(document, available, "release", version.getRelease());
        this.appendTextChild(document, available, "milestone", version.getMilestone());
        this.appendTextChild(document, available, "integration", version.getIntegration());
    }

    private final void writeExceededSection(Result result, Document document, Element response) {
        Element exceeded = document.createElement("exceeded");
        response.appendChild(exceeded);
        Intrinsics.checkNotNullExpressionValue((Object)exceeded, (String)"exceeded");
        this.appendTextChild(document, exceeded, "count", result.getExceeded().getCount());
        Element dependencies = document.createElement("dependencies");
        exceeded.appendChild(dependencies);
        for (DependencyLatest dependency : result.getExceeded().getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)dependencies, (String)"dependencies");
            Element element = this.writeDependency(document, dependencies, "exceededDependency", dependency);
            this.appendTextChild(document, element, "latest", dependency.getLatest());
        }
    }

    private final void writeUndeclaredSection(Result result, Document document, Element response) {
        Element undeclared = document.createElement("undeclared");
        response.appendChild(undeclared);
        Intrinsics.checkNotNullExpressionValue((Object)undeclared, (String)"undeclared");
        this.appendTextChild(document, undeclared, "count", result.getUndeclared().getCount());
        Element dependencies = document.createElement("dependencies");
        undeclared.appendChild(dependencies);
        for (Dependency dependency : result.getUndeclared().getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)dependencies, (String)"dependencies");
            this.writeDependency(document, dependencies, "dependency", dependency);
        }
    }

    private final void writeUnresolvedSection(Result result, Document document, Element response) {
        Element unresolved = document.createElement("unresolved");
        response.appendChild(unresolved);
        Intrinsics.checkNotNullExpressionValue((Object)unresolved, (String)"unresolved");
        this.appendTextChild(document, unresolved, "count", result.getUnresolved().getCount());
        Element dependencies = document.createElement("dependencies");
        unresolved.appendChild(dependencies);
        for (DependencyUnresolved dependency : result.getUnresolved().getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)dependencies, (String)"dependencies");
            Element element = this.writeDependency(document, dependencies, "unresolvedDependency", dependency);
            this.appendTextChild(document, element, "reason", dependency.getReason());
        }
    }

    private final void writeGradle(Result result, Document document, Element response) {
        Element gradle = document.createElement("gradle");
        response.appendChild(gradle);
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"gradle");
        this.appendTextChild(document, gradle, "enabled", result.getGradle().getEnabled());
        this.writeGradleUpdate(document, gradle, "running", result.getGradle().getRunning());
        this.writeGradleUpdate(document, gradle, "current", result.getGradle().getCurrent());
        this.writeGradleUpdate(document, gradle, "releaseCandidate", result.getGradle().getReleaseCandidate());
        this.writeGradleUpdate(document, gradle, "nightly", result.getGradle().getNightly());
    }

    private final void writeGradleUpdate(Document document, Element element, String name, GradleUpdateResult update) {
        Element channel = document.createElement(name);
        element.appendChild(channel);
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        this.appendTextChild(document, channel, "version", update.getVersion());
        this.appendTextChild(document, channel, "isUpdateAvailable", update.isUpdateAvailable());
        this.appendTextChild(document, channel, "isFailure", update.isFailure());
        this.appendTextChild(document, channel, "reason", update.getReason());
    }

    private final Element writeDependency(Document document, Element element, String name, Dependency dependency) {
        Element dependencyElement = document.createElement(name);
        element.appendChild(dependencyElement);
        Intrinsics.checkNotNullExpressionValue((Object)dependencyElement, (String)"dependencyElement");
        this.appendTextChild(document, dependencyElement, "group", dependency.getGroup());
        this.appendTextChild(document, dependencyElement, "name", dependency.getName());
        this.appendTextChild(document, dependencyElement, "version", dependency.getVersion());
        this.appendTextChild(document, dependencyElement, "projectUrl", dependency.getProjectUrl());
        this.appendTextChild(document, dependencyElement, "userReason", dependency.getUserReason());
        return dependencyElement;
    }

    private final void appendTextChild(Document document, Element parent, String name, Object textContent) {
        if (textContent != null) {
            Element element = document.createElement(name);
            element.setTextContent(textContent.toString());
            parent.appendChild(element);
        }
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "xml";
    }
}

