/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.updates.gradle;

import com.github.benmanes.gradle.versions.updates.gradle.GradleReleaseChannel;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import com.squareup.moshi.kotlin.reflect.KotlinJsonAdapterFactory;
import java.io.Closeable;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\b\u0010\t\u001a\u0004\u0018\u00010\bJ\b\u0010\n\u001a\u0004\u0018\u00010\bJ\u0006\u0010\u000b\u001a\u00020\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker;", "", "enabled", "", "(Z)V", "getEnabled", "()Z", "getCurrentGradleVersion", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "getNightlyGradleVersion", "getReleaseCandidateGradleVersion", "getRunningGradleVersion", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Available;", "Companion", "ReleaseStatus", "gradle-versions-plugin"})
public final class GradleUpdateChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enabled;
    @NotNull
    private static final EnumMap<GradleReleaseChannel, ReleaseStatus> cacheMap = new EnumMap(GradleReleaseChannel.class);
    @NotNull
    private static final String API_BASE_URL = "https://services.gradle.org/versions/";
    private static final long CLIENT_TIME_OUT = 15000L;
    @NotNull
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(15000L, TimeUnit.SECONDS).writeTimeout(15000L, TimeUnit.SECONDS).readTimeout(15000L, TimeUnit.SECONDS).build();
    private static final Moshi moshi = new Moshi.Builder().addLast((JsonAdapter.Factory)new KotlinJsonAdapterFactory()).build();

    public GradleUpdateChecker(boolean enabled) {
        this.enabled = enabled;
        if (this.enabled) {
            GradleUpdateChecker.Companion.fetch();
        }
    }

    public /* synthetic */ GradleUpdateChecker(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    @NotNull
    public final ReleaseStatus.Available getRunningGradleVersion() {
        GradleVersion gradleVersion = GradleVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"current()");
        return new ReleaseStatus.Available(gradleVersion);
    }

    @Nullable
    public final ReleaseStatus getCurrentGradleVersion() {
        return cacheMap.get((Object)GradleReleaseChannel.CURRENT);
    }

    @Nullable
    public final ReleaseStatus getReleaseCandidateGradleVersion() {
        return cacheMap.get((Object)GradleReleaseChannel.RELEASE_CANDIDATE);
    }

    @Nullable
    public final ReleaseStatus getNightlyGradleVersion() {
        return cacheMap.get((Object)GradleReleaseChannel.NIGHTLY);
    }

    public GradleUpdateChecker() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$Companion;", "", "()V", "API_BASE_URL", "", "CLIENT_TIME_OUT", "", "cacheMap", "Ljava/util/EnumMap;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleReleaseChannel;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "client", "Lokhttp3/OkHttpClient;", "moshi", "Lcom/squareup/moshi/Moshi;", "kotlin.jvm.PlatformType", "fetch", "", "VersionSite", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void fetch() {
            for (GradleReleaseChannel it : GradleReleaseChannel.values()) {
                try {
                    Closeable closeable = (Closeable)client.newCall(new Request.Builder().url(GradleUpdateChecker.API_BASE_URL + it.getId()).build()).execute();
                    Throwable throwable = null;
                    try {
                        Unit unit;
                        Response response = (Response)closeable;
                        boolean bl = false;
                        ResponseBody responseBody = response.body();
                        if (responseBody != null && (responseBody = responseBody.source()) != null) {
                            String version;
                            ResponseBody body = responseBody;
                            boolean bl2 = false;
                            VersionSite versionSite = (VersionSite)moshi.adapter(VersionSite.class).fromJson((BufferedSource)body);
                            String string = versionSite != null ? versionSite.getVersion() : null;
                            if (string == null) {
                                string = "";
                            }
                            if (((CharSequence)(version = string)).length() > 0) {
                                Map map = cacheMap;
                                GradleVersion gradleVersion = GradleVersion.version((String)version);
                                Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"version(version)");
                                ReleaseStatus.Available available = new ReleaseStatus.Available(gradleVersion);
                                map.put(it, available);
                            } else {
                                ((Map)cacheMap).put(it, ReleaseStatus.Unavailable.INSTANCE);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Exception e) {
                    Map map = cacheMap;
                    String string = e.getMessage();
                    if (string == null) {
                        string = "";
                    }
                    map.put(it, new ReleaseStatus.Failure(string));
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$Companion$VersionSite;", "", "()V", "version", "", "getVersion", "()Ljava/lang/String;", "setVersion", "(Ljava/lang/String;)V", "gradle-versions-plugin"})
        private static final class VersionSite {
            @Nullable
            private String version;

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            public final void setVersion(@Nullable String string) {
                this.version = string;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "", "()V", "Available", "Failure", "Unavailable", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Available;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Failure;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Unavailable;", "gradle-versions-plugin"})
    public static abstract class ReleaseStatus {
        private ReleaseStatus() {
        }

        public /* synthetic */ ReleaseStatus(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Available;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "gradleVersion", "Lorg/gradle/util/GradleVersion;", "(Lorg/gradle/util/GradleVersion;)V", "getGradleVersion", "()Lorg/gradle/util/GradleVersion;", "gradle-versions-plugin"})
        public static final class Available
        extends ReleaseStatus {
            @NotNull
            private final GradleVersion gradleVersion;

            public Available(@NotNull GradleVersion gradleVersion) {
                Intrinsics.checkNotNullParameter((Object)gradleVersion, (String)"gradleVersion");
                super(null);
                this.gradleVersion = gradleVersion;
            }

            @NotNull
            public final GradleVersion getGradleVersion() {
                return this.gradleVersion;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Failure;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "reason", "", "(Ljava/lang/String;)V", "getReason", "()Ljava/lang/String;", "gradle-versions-plugin"})
        public static final class Failure
        extends ReleaseStatus {
            @NotNull
            private final String reason;

            public Failure(@NotNull String reason) {
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                super(null);
                this.reason = reason;
            }

            @NotNull
            public final String getReason() {
                return this.reason;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus$Unavailable;", "Lcom/github/benmanes/gradle/versions/updates/gradle/GradleUpdateChecker$ReleaseStatus;", "()V", "gradle-versions-plugin"})
        public static final class Unavailable
        extends ReleaseStatus {
            @NotNull
            public static final Unavailable INSTANCE = new Unavailable();

            private Unavailable() {
                super(null);
            }
        }
    }
}

