/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.reporter;

import com.github.benmanes.gradle.versions.reporter.AbstractReporter;
import com.github.benmanes.gradle.versions.reporter.AbstractReporterKt;
import com.github.benmanes.gradle.versions.reporter.result.Dependency;
import com.github.benmanes.gradle.versions.reporter.result.DependencyLatest;
import com.github.benmanes.gradle.versions.reporter.result.DependencyOutdated;
import com.github.benmanes.gradle.versions.reporter.result.DependencyUnresolved;
import com.github.benmanes.gradle.versions.reporter.result.Result;
import com.github.benmanes.gradle.versions.updates.gradle.GradleReleaseChannel;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\r\u001a\u00020\u0005H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/github/benmanes/gradle/versions/reporter/PlainTextReporter;", "Lcom/github/benmanes/gradle/versions/reporter/AbstractReporter;", "project", "Lorg/gradle/api/Project;", "revision", "", "gradleReleaseChannel", "(Lorg/gradle/api/Project;Ljava/lang/String;Ljava/lang/String;)V", "getGradleReleaseChannel", "()Ljava/lang/String;", "getProject", "()Lorg/gradle/api/Project;", "getRevision", "getFileExtension", "write", "", "printStream", "Ljava/io/OutputStream;", "result", "Lcom/github/benmanes/gradle/versions/reporter/result/Result;", "writeExceedLatestFound", "writeGradleUpdates", "writeHeader", "writeUndeclared", "writeUnresolved", "writeUpToDate", "writeUpgrades", "Companion", "gradle-versions-plugin"})
public final class PlainTextReporter
extends AbstractReporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final String revision;
    @NotNull
    private final String gradleReleaseChannel;

    public PlainTextReporter(@NotNull Project project, @NotNull String revision, @NotNull String gradleReleaseChannel) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)revision, (String)"revision");
        Intrinsics.checkNotNullParameter((Object)gradleReleaseChannel, (String)"gradleReleaseChannel");
        super(project, revision, gradleReleaseChannel);
        this.project = project;
        this.revision = revision;
        this.gradleReleaseChannel = gradleReleaseChannel;
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getRevision() {
        return this.revision;
    }

    @Override
    @NotNull
    public String getGradleReleaseChannel() {
        return this.gradleReleaseChannel;
    }

    @Override
    public void write(@NotNull OutputStream printStream, @NotNull Result result) {
        Intrinsics.checkNotNullParameter((Object)printStream, (String)"printStream");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.writeHeader(printStream);
        if (result.getCount() == 0) {
            AbstractReporterKt.println$default(printStream, null, 1, null);
            AbstractReporterKt.println(printStream, "No dependencies found.");
        } else {
            this.writeUpToDate(printStream, result);
            this.writeExceedLatestFound(printStream, result);
            this.writeUpgrades(printStream, result);
            this.writeUndeclared(printStream, result);
            this.writeUnresolved(printStream, result);
        }
        this.writeGradleUpdates(printStream, result);
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "txt";
    }

    private final void writeHeader(OutputStream printStream) {
        AbstractReporterKt.println$default(printStream, null, 1, null);
        AbstractReporterKt.println(printStream, "------------------------------------------------------------");
        AbstractReporterKt.println(printStream, this.getProject().getPath() + " Project Dependency Updates (report to plain text file)");
        AbstractReporterKt.println(printStream, "------------------------------------------------------------");
    }

    private final void writeUpToDate(OutputStream printStream, Result result) {
        Set<Dependency> upToDateVersions = result.getCurrent().getDependencies();
        if (!((Collection)upToDateVersions).isEmpty()) {
            AbstractReporterKt.println$default(printStream, null, 1, null);
            AbstractReporterKt.println(printStream, "The following dependencies are using the latest " + this.getRevision() + " version:");
            for (Dependency dependency : upToDateVersions) {
                AbstractReporterKt.println(printStream, " - " + PlainTextReporter.Companion.label(dependency) + ':' + dependency.getVersion());
                if (dependency.getUserReason() != null) {
                    String it;
                    boolean bl = false;
                    AbstractReporterKt.println(printStream, "     " + it);
                }
            }
        }
    }

    private final void writeExceedLatestFound(OutputStream printStream, Result result) {
        Set<DependencyLatest> downgradeVersions = result.getExceeded().getDependencies();
        if (!((Collection)downgradeVersions).isEmpty()) {
            AbstractReporterKt.println$default(printStream, null, 1, null);
            AbstractReporterKt.println(printStream, "The following dependencies exceed the version found at the " + this.getRevision() + " revision level:");
            for (DependencyLatest dependency : downgradeVersions) {
                String it;
                String currentVersion = dependency.getVersion();
                AbstractReporterKt.println(printStream, " - " + PlainTextReporter.Companion.label(dependency) + " [" + currentVersion + " <- " + dependency.getLatest() + ']');
                if (dependency.getUserReason() != null) {
                    boolean bl = false;
                    AbstractReporterKt.println(printStream, "     " + it);
                }
                if (dependency.getProjectUrl() == null) continue;
                boolean bl = false;
                AbstractReporterKt.println(printStream, "     " + it);
            }
        }
    }

    private final void writeUpgrades(OutputStream printStream, Result result) {
        Set<DependencyOutdated> upgradeVersions = result.getOutdated().getDependencies();
        if (!((Collection)upgradeVersions).isEmpty()) {
            AbstractReporterKt.println$default(printStream, null, 1, null);
            AbstractReporterKt.println(printStream, "The following dependencies have later " + this.getRevision() + " versions:");
            for (DependencyOutdated dependency : upgradeVersions) {
                String it;
                String currentVersion = dependency.getVersion();
                AbstractReporterKt.println(printStream, " - " + PlainTextReporter.Companion.label(dependency) + " [" + currentVersion + " -> " + dependency.getAvailable().get(this.getRevision()) + ']');
                if (dependency.getUserReason() != null) {
                    boolean bl = false;
                    AbstractReporterKt.println(printStream, "     " + it);
                }
                if (dependency.getProjectUrl() == null) continue;
                boolean bl = false;
                AbstractReporterKt.println(printStream, "     " + it);
            }
        }
    }

    private final void writeUndeclared(OutputStream printStream, Result result) {
        Set<Dependency> undeclaredVersions = result.getUndeclared().getDependencies();
        if (!((Collection)undeclaredVersions).isEmpty()) {
            AbstractReporterKt.println$default(printStream, null, 1, null);
            AbstractReporterKt.println(printStream, "Failed to compare versions for the following dependencies because they were declared without version:");
            for (Dependency dependency : undeclaredVersions) {
                AbstractReporterKt.println(printStream, " - " + PlainTextReporter.Companion.label(dependency));
            }
        }
    }

    private final void writeUnresolved(OutputStream printStream, Result result) {
        Set<DependencyUnresolved> unresolved = result.getUnresolved().getDependencies();
        if (!((Collection)unresolved).isEmpty()) {
            AbstractReporterKt.println$default(printStream, null, 1, null);
            AbstractReporterKt.println(printStream, "Failed to determine the latest version for the following dependencies (use --info for details):");
            for (DependencyUnresolved dependency : unresolved) {
                String it;
                AbstractReporterKt.println(printStream, " - " + PlainTextReporter.Companion.label(dependency));
                if (dependency.getUserReason() != null) {
                    boolean bl = false;
                    AbstractReporterKt.println(printStream, "     " + it);
                }
                if (dependency.getProjectUrl() != null) {
                    boolean bl = false;
                    AbstractReporterKt.println(printStream, "     " + it);
                }
                this.getProject().getLogger().info("The exception that is the cause of unresolved state: {}", (Object)dependency.getReason());
            }
        }
    }

    private final void writeGradleUpdates(OutputStream printStream, Result result) {
        if (!result.getGradle().getEnabled()) {
            return;
        }
        AbstractReporterKt.println$default(printStream, null, 1, null);
        AbstractReporterKt.println(printStream, "Gradle " + this.getGradleReleaseChannel() + " updates:");
        if (result.getGradle().getCurrent().isFailure()) {
            AbstractReporterKt.println(printStream, "[ERROR] [release channel: " + GradleReleaseChannel.CURRENT.getId() + "] " + result.getGradle().getCurrent().getReason());
        }
        if ((Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.RELEASE_CANDIDATE.getId()) || Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId())) && result.getGradle().getReleaseCandidate().isFailure()) {
            AbstractReporterKt.println(printStream, "[ERROR] [release channel: " + GradleReleaseChannel.RELEASE_CANDIDATE.getId() + "] " + result.getGradle().getReleaseCandidate().getReason());
        }
        if (Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId()) && result.getGradle().getNightly().isFailure()) {
            AbstractReporterKt.println(printStream, "[ERROR] [release channel: " + GradleReleaseChannel.NIGHTLY.getId() + "] " + result.getGradle().getNightly().getReason());
        }
        AbstractReporterKt.print(printStream, " - Gradle: [" + result.getGradle().getRunning().getVersion());
        boolean updatePrinted = false;
        if (result.getGradle().getCurrent().isUpdateAvailable() && result.getGradle().getCurrent().compareTo(result.getGradle().getRunning()) > 0) {
            updatePrinted = true;
            AbstractReporterKt.print(printStream, " -> " + result.getGradle().getCurrent().getVersion());
        }
        if ((Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.RELEASE_CANDIDATE.getId()) || Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId())) && result.getGradle().getReleaseCandidate().isUpdateAvailable() && result.getGradle().getReleaseCandidate().compareTo(result.getGradle().getCurrent()) > 0) {
            updatePrinted = true;
            AbstractReporterKt.print(printStream, " -> " + result.getGradle().getReleaseCandidate().getVersion());
        }
        if (Intrinsics.areEqual((Object)this.getGradleReleaseChannel(), (Object)GradleReleaseChannel.NIGHTLY.getId()) && result.getGradle().getNightly().isUpdateAvailable() && result.getGradle().getNightly().compareTo(result.getGradle().getCurrent()) > 0) {
            updatePrinted = true;
            AbstractReporterKt.print(printStream, " -> " + result.getGradle().getNightly().getVersion());
        }
        if (!updatePrinted) {
            AbstractReporterKt.print(printStream, ": UP-TO-DATE");
        }
        AbstractReporterKt.println(printStream, "]");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0007"}, d2={"Lcom/github/benmanes/gradle/versions/reporter/PlainTextReporter$Companion;", "", "()V", "label", "", "dependency", "Lcom/github/benmanes/gradle/versions/reporter/result/Dependency;", "gradle-versions-plugin"})
    public static final class Companion {
        private Companion() {
        }

        private final String label(Dependency dependency) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = dependency.getGroup();
            if (string == null) {
                string = "";
            }
            return stringBuilder.append(string).append(':').append(dependency.getName()).toString();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

