/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.adaptive;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Var;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="adaptive.Car")
public final class CarPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final int maximumSize;
    private final Node headT1;
    private final Node headT2;
    private final Node headB1;
    private final Node headB2;
    private int sizeT1;
    private int sizeT2;
    private int sizeB1;
    private int sizeB2;
    private int p;

    public CarPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.headT1 = new Node();
        this.headT2 = new Node();
        this.headB1 = new Node();
        this.headB2 = new Node();
    }

    @Override
    public void record(long key) {
        Node node = (Node)this.data.get(key);
        if (CarPolicy.isHit(node)) {
            this.policyStats.recordHit();
            this.onHit(node);
        } else {
            this.policyStats.recordMiss();
            this.onMiss(key, node);
        }
    }

    private static boolean isHit(Node node) {
        return node != null && (node.type == QueueType.T1 || node.type == QueueType.T2);
    }

    private void onHit(Node node) {
        node.marked = true;
        this.policyStats.recordOperation();
    }

    private void onMiss(long key, @Var Node node) {
        this.policyStats.recordOperation();
        if (this.sizeT1 + this.sizeT2 == this.maximumSize) {
            this.demote();
            if (!CarPolicy.isGhost(node)) {
                if (this.sizeT1 + this.sizeB1 == this.maximumSize) {
                    Node victim = Objects.requireNonNull(this.headB1.next);
                    this.data.remove(victim.key);
                    victim.remove();
                    --this.sizeB1;
                } else if (this.sizeT1 + this.sizeT2 + this.sizeB1 + this.sizeB2 == 2 * this.maximumSize) {
                    Node victim = Objects.requireNonNull(this.headB2.next);
                    this.data.remove(victim.key);
                    victim.remove();
                    --this.sizeB2;
                }
            }
        }
        if (!CarPolicy.isGhost(node)) {
            Preconditions.checkState((node == null ? 1 : 0) != 0);
            node = new Node(key);
            node.appendToTail(this.headT1);
            node.type = QueueType.T1;
            this.data.put(key, (Object)node);
            ++this.sizeT1;
        } else if (node.type == QueueType.B1) {
            this.p = Math.min(this.p + Math.max(1, this.sizeB2 / this.sizeB1), this.maximumSize);
            node.remove();
            --this.sizeB1;
            node.appendToTail(this.headT2);
            node.type = QueueType.T2;
            ++this.sizeT2;
            node.marked = false;
        } else if (node.type == QueueType.B2) {
            this.p = Math.max(this.p - Math.max(1, this.sizeB1 / this.sizeB2), 0);
            node.remove();
            --this.sizeB2;
            node.appendToTail(this.headT2);
            node.type = QueueType.T2;
            ++this.sizeT2;
            node.marked = false;
        } else {
            throw new IllegalStateException();
        }
    }

    private static boolean isGhost(Node node) {
        return node != null && (node.type == QueueType.B1 || node.type == QueueType.B2);
    }

    private void demote() {
        this.policyStats.recordEviction();
        while (true) {
            Node candidate;
            this.policyStats.recordOperation();
            if (this.sizeT1 >= Math.max(1, this.p)) {
                candidate = Objects.requireNonNull(this.headT1.next);
                if (!candidate.marked) {
                    candidate.remove();
                    --this.sizeT1;
                    candidate.appendToTail(this.headB1);
                    candidate.type = QueueType.B1;
                    ++this.sizeB1;
                    return;
                }
                candidate.marked = false;
                candidate.remove();
                --this.sizeT1;
                candidate.appendToTail(this.headT2);
                candidate.type = QueueType.T2;
                ++this.sizeT2;
                continue;
            }
            candidate = Objects.requireNonNull(this.headT2.next);
            if (!candidate.marked) {
                candidate.remove();
                --this.sizeT2;
                candidate.appendToTail(this.headB2);
                candidate.type = QueueType.B2;
                ++this.sizeB2;
                return;
            }
            candidate.marked = false;
            candidate.remove();
            candidate.appendToTail(this.headT2);
            candidate.type = QueueType.T2;
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Preconditions.checkState(((long)this.sizeT1 == this.data.values().stream().filter(node -> node.type == QueueType.T1).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeT2 == this.data.values().stream().filter(node -> node.type == QueueType.T2).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeB1 == this.data.values().stream().filter(node -> node.type == QueueType.B1).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeB2 == this.data.values().stream().filter(node -> node.type == QueueType.B2).count() ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeT1 + this.sizeT2 <= this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeB1 + this.sizeB2 <= this.maximumSize ? 1 : 0) != 0);
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        @Nullable QueueType type;
        boolean marked;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
        }

        public void appendToTail(Node head) {
            Node tail = Objects.requireNonNull(head.prev);
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
            this.type = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    private static enum QueueType {
        T1,
        B1,
        T2,
        B2;

    }
}

