/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.DoubleSupplier;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jspecify.annotations.Nullable;

public class PolicyStats {
    private final Map<String, Metric> metrics;
    private final Stopwatch stopwatch = Stopwatch.createUnstarted();
    private final String name;
    private long hitCount;
    private long missCount;
    private long hitsWeight;
    private long missesWeight;
    private double hitPenalty;
    private double missPenalty;
    private long evictionCount;
    private long admittedCount;
    private long rejectedCount;
    private long operationCount;
    private double percentAdaption;

    public PolicyStats(String format, Object ... args) {
        this.name = String.format(Locale.US, format, args);
        this.metrics = new LinkedHashMap<String, Metric>();
        this.addMetric(new Metric.Builder().name("Policy").value(this::name).type(Metric.MetricType.OBJECT).required(true));
        this.addMetric(new Metric.Builder().name("Hit Rate").value(this::hitRate).type(Metric.MetricType.PERCENT).required(true));
        this.addMetric(new Metric.Builder().name("Miss Rate").value(this::missRate).type(Metric.MetricType.PERCENT).required(true));
        this.addMetric(new Metric.Builder().name("Hits").value(this::hitCount).type(Metric.MetricType.NUMBER).required(true));
        this.addMetric(new Metric.Builder().name("Misses").value(this::missCount).type(Metric.MetricType.NUMBER).required(true));
        this.addMetric(new Metric.Builder().name("Misses").value(this::missCount).type(Metric.MetricType.NUMBER).required(true));
        this.addMetric(new Metric.Builder().name("Requests").value(this::requestCount).type(Metric.MetricType.NUMBER).required(true));
        this.addMetric(new Metric.Builder().name("Evictions").value(this::evictionCount).type(Metric.MetricType.NUMBER).required(true));
        this.addPercentMetric("Admit rate", () -> this.admittedCount + this.rejectedCount == 0L ? 0.0 : this.admissionRate());
        this.addMetric(new Metric.Builder().name("Requests Weight").value(this::requestsWeight).type(Metric.MetricType.NUMBER).characteristic(Policy.Characteristic.WEIGHTED));
        this.addMetric(new Metric.Builder().name("Weighted Hit Rate").value(this::weightedHitRate).characteristic(Policy.Characteristic.WEIGHTED).type(Metric.MetricType.PERCENT));
        this.addMetric(new Metric.Builder().name("Weighted Miss Rate").value(this::weightedMissRate).type(Metric.MetricType.PERCENT).characteristic(Policy.Characteristic.WEIGHTED));
        this.addPercentMetric("Adaption", this::percentAdaption);
        this.addMetric("Average Miss Penalty", this::averageMissPenalty);
        this.addMetric("Average Penalty", this::averagePenalty);
        this.addMetric("Steps", this::operationCount);
        this.addMetric("Time", this::stopwatch);
    }

    public void addMetric(Metric.Builder metricBuilder) {
        Metric metric = metricBuilder.build();
        this.metrics.put(metric.name(), Objects.requireNonNull(metric));
    }

    public void addMetric(String name, Supplier<?> supplier) {
        this.addMetric(new Metric.Builder().name(name).value(supplier).type(Metric.MetricType.OBJECT));
    }

    public void addMetric(String name, LongSupplier supplier) {
        this.addMetric(new Metric.Builder().name(name).value(supplier).type(Metric.MetricType.NUMBER));
    }

    public void addMetric(String name, DoubleSupplier supplier) {
        this.addMetric(new Metric.Builder().name(name).value(supplier).type(Metric.MetricType.NUMBER));
    }

    public void addPercentMetric(String name, DoubleSupplier supplier) {
        this.addMetric(new Metric.Builder().name(name).value(supplier).type(Metric.MetricType.PERCENT));
    }

    public Map<String, Metric> metrics() {
        return this.metrics;
    }

    public Stopwatch stopwatch() {
        return this.stopwatch;
    }

    public String name() {
        return this.name;
    }

    public void recordOperation() {
        ++this.operationCount;
    }

    public long operationCount() {
        return this.operationCount;
    }

    public void addOperations(long operations) {
        this.operationCount += operations;
    }

    public void recordHit() {
        ++this.hitCount;
    }

    public long hitCount() {
        return this.hitCount;
    }

    public void addHits(long hits) {
        this.hitCount += hits;
    }

    public void recordWeightedHit(int weight) {
        this.hitsWeight += (long)weight;
        this.recordHit();
    }

    public long hitsWeight() {
        return this.hitsWeight;
    }

    public void recordHitPenalty(double penalty) {
        this.hitPenalty += penalty;
    }

    public double hitPenalty() {
        return this.hitPenalty;
    }

    public void recordMiss() {
        ++this.missCount;
    }

    public long missCount() {
        return this.missCount;
    }

    public void addMisses(long misses) {
        this.missCount += misses;
    }

    public void recordWeightedMiss(int weight) {
        this.missesWeight += (long)weight;
        this.recordMiss();
    }

    public long missesWeight() {
        return this.missesWeight;
    }

    public void recordMissPenalty(double penalty) {
        this.missPenalty += penalty;
    }

    public double missPenalty() {
        return this.missPenalty;
    }

    public long evictionCount() {
        return this.evictionCount;
    }

    public void recordEviction() {
        ++this.evictionCount;
    }

    public void addEvictions(long evictions) {
        this.evictionCount += evictions;
    }

    public long requestCount() {
        return this.hitCount + this.missCount;
    }

    public long requestsWeight() {
        return this.hitsWeight + this.missesWeight;
    }

    public long admissionCount() {
        return this.admittedCount;
    }

    public void recordAdmission() {
        ++this.admittedCount;
    }

    public long rejectionCount() {
        return this.rejectedCount;
    }

    public void recordRejection() {
        ++this.rejectedCount;
    }

    public double totalPenalty() {
        return this.hitPenalty + this.missPenalty;
    }

    public double percentAdaption() {
        return this.percentAdaption;
    }

    public void setPercentAdaption(double percentAdaption) {
        this.percentAdaption = Math.floor(100.0 * percentAdaption) / 100.0;
    }

    public double hitRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 1.0 : (double)this.hitCount / (double)requestCount;
    }

    public double weightedHitRate() {
        long requestsWeight = this.requestsWeight();
        return requestsWeight == 0L ? 1.0 : (double)this.hitsWeight / (double)requestsWeight;
    }

    public double missRate() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.missCount / (double)requestCount;
    }

    public double weightedMissRate() {
        long requestsWeight = this.requestsWeight();
        return requestsWeight == 0L ? 1.0 : (double)this.missesWeight / (double)requestsWeight;
    }

    public double admissionRate() {
        long candidateCount = this.admittedCount + this.rejectedCount;
        return candidateCount == 0L ? 1.0 : (double)this.admittedCount / (double)candidateCount;
    }

    public double complexity() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : (double)this.operationCount / (double)requestCount;
    }

    public double averagePenalty() {
        long requestCount = this.requestCount();
        return requestCount == 0L ? 0.0 : this.totalPenalty() / (double)requestCount;
    }

    public double averageHitPenalty() {
        return this.hitCount == 0L ? 0.0 : this.hitPenalty / (double)this.hitCount;
    }

    public double averageMissPenalty() {
        return this.missCount == 0L ? 0.0 : this.missPenalty / (double)this.missCount;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    public record Metric(String name, Object value, MetricType type, ImmutableSet<Policy.Characteristic> characteristics, boolean required) {
        public Metric {
            Objects.requireNonNull(type);
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            Objects.requireNonNull(characteristics);
        }

        public static enum MetricType {
            NUMBER,
            PERCENT,
            OBJECT;

        }

        public static final class Builder {
            private final Set<Policy.Characteristic> characteristics = EnumSet.noneOf(Policy.Characteristic.class);
            private @Nullable MetricType type;
            private @Nullable Object value;
            private @Nullable String name;
            private boolean required;

            @CanIgnoreReturnValue
            public Builder characteristic(Policy.Characteristic characteristic) {
                this.characteristics.add(characteristic);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder name(String name) {
                this.name = Objects.requireNonNull(name);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder value(Object value) {
                this.value = Objects.requireNonNull(value);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder value(Supplier<?> value) {
                return this.value((Object)value);
            }

            @CanIgnoreReturnValue
            public Builder value(LongSupplier value) {
                return this.value((Object)value);
            }

            @CanIgnoreReturnValue
            public Builder value(DoubleSupplier value) {
                return this.value((Object)value);
            }

            @CanIgnoreReturnValue
            public Builder type(MetricType type) {
                this.type = Objects.requireNonNull(type);
                return this;
            }

            @CanIgnoreReturnValue
            public Builder required(boolean required) {
                this.required = required;
                return this;
            }

            public Metric build() {
                Objects.requireNonNull(this.type);
                Objects.requireNonNull(this.name);
                Objects.requireNonNull(this.value);
                return new Metric(this.name, this.value, this.type, (ImmutableSet<Policy.Characteristic>)Sets.immutableEnumSet(this.characteristics), this.required);
            }
        }
    }
}

