/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.membership.bloom;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Var;
import com.typesafe.config.Config;
import java.util.Arrays;

public final class BloomFilter
implements Membership {
    static final long[] SEED = new long[]{-4348849565147123417L, -5435081209227447693L, -7286425919675154353L, -3750763034362895579L};
    static final int BITS_PER_LONG_SHIFT = 6;
    static final int BITS_PER_LONG_MASK = 63;
    int tableShift;
    long[] table;

    public BloomFilter() {
    }

    public BloomFilter(Config config) {
        BasicSettings.MembershipSettings settings = new BasicSettings(config).membership();
        this.ensureCapacity(settings.expectedInsertions(), settings.fpp());
    }

    public void ensureCapacity(long expectedInsertions, double fpp) {
        Preconditions.checkArgument((expectedInsertions >= 0L ? 1 : 0) != 0);
        Preconditions.checkArgument((fpp > 0.0 && fpp < 1.0 ? 1 : 0) != 0);
        double optimalBitsFactor = -Math.log(fpp) / (Math.log(2.0) * Math.log(2.0));
        int optimalNumberOfBits = (int)((double)expectedInsertions * optimalBitsFactor);
        int optimalSize = Math.max(2, optimalNumberOfBits >>> 6);
        if (this.table == null || this.table.length < optimalSize) {
            int powerOfTwoShift = 32 - Integer.numberOfLeadingZeros(optimalSize - 1);
            this.tableShift = 32 - powerOfTwoShift;
            this.table = new long[1 << powerOfTwoShift];
        }
    }

    @Override
    public boolean mightContain(long e) {
        int item = this.spread(Long.hashCode(e));
        for (int i = 0; i < 4; ++i) {
            int hash = BloomFilter.seeded(item, i);
            int index = hash >>> this.tableShift;
            if ((this.table[index] & BloomFilter.bitmask(hash)) != 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public void clear() {
        Arrays.fill(this.table, 0L);
    }

    @Override
    public boolean put(long e) {
        int item = this.spread(Long.hashCode(e));
        return this.setAt(item, 0) | this.setAt(item, 1) | this.setAt(item, 2) | this.setAt(item, 3);
    }

    boolean setAt(int item, int seedIndex) {
        int hash = BloomFilter.seeded(item, seedIndex);
        int index = hash >>> this.tableShift;
        long previous = this.table[index];
        int n = index;
        this.table[n] = this.table[n] | BloomFilter.bitmask(hash);
        return this.table[index] != previous;
    }

    int spread(@Var int x) {
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * 73244475;
        return x >>> 16 ^ x;
    }

    static int seeded(int item, int i) {
        long hash = ((long)item + SEED[i]) * SEED[i];
        hash += hash >>> 32;
        return (int)hash;
    }

    static long bitmask(int hash) {
        return 1L << (hash & 0x3F);
    }
}

