/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.tinycache;

import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashFunctionParser;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.HashedItem;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheSketch;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinySetIndexing;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Random;

public final class TinyCacheWithGhostCache {
    private static final int sampleSize = 10;
    private final HashFunctionParser hashFunc;
    private final TinyCacheSketch ghostCache;
    private final TinySetIndexing indexing;
    private final long[] chainIndex;
    private final long[] lastIndex;
    private final int itemsPerSet;
    private final long[] cache;
    private final Random rnd;

    public TinyCacheWithGhostCache(int nrSets, int itemsPerSet, int randomSeed) {
        this.ghostCache = new TinyCacheSketch(nrSets * 10, itemsPerSet, randomSeed + 1);
        this.hashFunc = new HashFunctionParser(nrSets);
        this.cache = new long[nrSets * itemsPerSet];
        this.indexing = new TinySetIndexing();
        this.chainIndex = new long[nrSets];
        this.lastIndex = new long[nrSets];
        this.rnd = new Random(randomSeed);
        this.itemsPerSet = itemsPerSet;
    }

    public boolean contains(long item) {
        this.hashFunc.createHash(item);
        if (!this.indexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], this.hashFunc.fpaux.chainId)) {
            return false;
        }
        this.indexing.getChain(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        int offset = this.itemsPerSet * this.hashFunc.fpaux.set;
        this.indexing.setChainStart(this.indexing.getChainStart() + offset);
        this.indexing.setChainEnd(this.indexing.getChainEnd() + offset);
        while (this.indexing.getChainStart() <= this.indexing.getChainEnd()) {
            try {
                if (this.cache[this.indexing.getChainStart() % this.cache.length] == this.hashFunc.fpaux.value) {
                    return true;
                }
                this.indexing.setChainStart(this.indexing.getChainStart() + 1);
            }
            catch (RuntimeException runtimeException) {
                System.out.println("length: " + this.cache.length + " Access: " + this.indexing.getChainStart());
            }
        }
        return false;
    }

    @CanIgnoreReturnValue
    private int replace(HashedItem fpaux, byte victim, int bucketStart, int removedOffset) {
        byte chainId = fpaux.chainId;
        fpaux.chainId = victim;
        this.cache[bucketStart + removedOffset] = 0L;
        this.indexing.removeItem(fpaux, this.chainIndex, this.lastIndex);
        fpaux.chainId = chainId;
        int idxToAdd = this.indexing.addItem(fpaux, this.chainIndex, this.lastIndex);
        int delta = removedOffset < idxToAdd ? -1 : 1;
        this.replaceItems(idxToAdd, fpaux.value, bucketStart, delta);
        return removedOffset;
    }

    public void recordItem(long item) {
        if (this.ghostCache.countItem(this.hashFunc.fpaux.value) < 10) {
            this.ghostCache.addItem(this.hashFunc.fpaux.value);
        }
    }

    public boolean addItem(long item) {
        this.hashFunc.createHash(item);
        int bucketStart = this.itemsPerSet * this.hashFunc.fpaux.set;
        if (this.cache[bucketStart + this.itemsPerSet - 1] != 0L) {
            return this.selectVictim(bucketStart);
        }
        int idxToAdd = this.indexing.addItem(this.hashFunc.fpaux, this.chainIndex, this.lastIndex);
        this.replaceItems(idxToAdd, this.hashFunc.fpaux.value, bucketStart, 1);
        return false;
    }

    private boolean selectVictim(int bucketStart) {
        byte victimOffset = (byte)this.rnd.nextInt(this.itemsPerSet);
        int victimChain = this.indexing.getChainAtOffset(this.hashFunc.fpaux, this.chainIndex, this.lastIndex, victimOffset);
        long victim = this.cache[bucketStart + victimOffset];
        if (this.indexing.chainExist(this.chainIndex[this.hashFunc.fpaux.set], victimChain)) {
            int victimScore = this.ghostCache.countItem(victim);
            int currItemScore = this.ghostCache.countItem(this.hashFunc.fpaux.value);
            if (currItemScore > victimScore) {
                this.replace(this.hashFunc.fpaux, (byte)victimChain, bucketStart, victimOffset);
                return true;
            }
            return false;
        }
        throw new IllegalStateException("Failed to replace");
    }

    private void replaceItems(int idx, @Var long value, @Var int start, int delta) {
        start += idx;
        do {
            long entry = this.cache[start];
            this.cache[start] = value;
            value = entry;
            start += delta;
        } while (value != 0L);
    }
}

