/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch;

import com.clearspring.analytics.stream.StreamSummary;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.PeriodicResetCountMin4;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.Arrays;
import java.util.stream.IntStream;
import org.apache.commons.math3.stat.regression.SimpleRegression;

public final class Indicator {
    private final int k;
    private final int ssSize;
    private final Hinter hinter;
    private final EstSkew estSkew;
    private final PeriodicResetCountMin4 sketch;
    private long sample;

    public Indicator(Config config) {
        IndicatorSettings settings = new IndicatorSettings(config);
        this.sketch = new PeriodicResetCountMin4(ConfigFactory.parseString((String)"maximum-size = 5000").withFallback((ConfigMergeable)config));
        this.ssSize = settings.ssSize();
        this.estSkew = new EstSkew();
        this.hinter = new Hinter();
        this.k = settings.k();
    }

    public void record(long key) {
        int hint = this.sketch.frequency(key);
        this.hinter.increment(hint);
        this.sketch.increment(key);
        this.estSkew.record(key);
        ++this.sample;
    }

    public void reset() {
        this.hinter.reset();
        this.estSkew.reset();
        this.sample = 0L;
    }

    public long getSample() {
        return this.sample;
    }

    public double getSkew() {
        return this.estSkew.estSkew(this.k);
    }

    public double getHint() {
        return this.hinter.getAverage();
    }

    public double getIndicator() {
        double skew = this.getSkew();
        return this.getHint() * (skew < 1.0 ? 1.0 - Math.pow(skew, 3.0) : 0.0) / 15.0;
    }

    public int[] getFreqs() {
        return this.hinter.freq;
    }

    static final class IndicatorSettings
    extends BasicSettings {
        public IndicatorSettings(Config config) {
            super(config);
        }

        public int k() {
            return this.config().getInt("indicator.k");
        }

        public int ssSize() {
            return this.config().getInt("indicator.ss-size");
        }
    }

    private final class EstSkew {
        StreamSummary<Long> stream;

        public EstSkew() {
            this.stream = new StreamSummary(Indicator.this.ssSize);
        }

        public void record(long key) {
            this.stream.offer((Object)key);
        }

        public void reset() {
            this.stream = new StreamSummary(Indicator.this.ssSize);
        }

        public IntStream getTopK(int k) {
            return this.stream.topK(k).stream().mapToInt(counter -> (int)counter.getCount());
        }

        public double estSkew(int k) {
            int[] idx = new int[]{1};
            SimpleRegression regression = new SimpleRegression();
            this.getTopK(k).forEachOrdered(freq -> {
                int n = idx[0];
                idx[0] = n + 1;
                regression.addData(Math.log(n), Math.log(freq));
            });
            return -regression.getSlope();
        }
    }

    private static final class Hinter {
        final int[] freq = new int[16];
        int sum;
        int count;

        private Hinter() {
        }

        public void increment(int i) {
            this.sum += i;
            ++this.count;
            int n = i;
            this.freq[n] = this.freq[n] + 1;
        }

        public void reset() {
            this.count = 0;
            this.sum = 0;
            Arrays.fill(this.freq, 0);
        }

        public double getAverage() {
            return (double)this.sum / (double)this.count;
        }
    }
}

