/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.Metrics;
import com.github.benmanes.caffeine.cache.simulator.report.Reporter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.typesafe.config.Config;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public abstract class TextReporter
implements Reporter {
    private final Set<Policy.Characteristic> characteristics;
    private final BasicSettings settings;

    protected TextReporter(Config config, Set<Policy.Characteristic> characteristics) {
        this.characteristics = Objects.requireNonNull(characteristics);
        this.settings = new BasicSettings(config);
    }

    @Override
    public void print(List<PolicyStats> results) {
        ImmutableList<PolicyStats> sortedStats = this.getSortedStats(results);
        ImmutableSet<String> headers = this.getHeaders((Collection<PolicyStats>)sortedStats);
        String report = this.assemble((Set<String>)headers, (List<PolicyStats>)sortedStats);
        String output = this.settings.report().output();
        if (output.equalsIgnoreCase("console")) {
            System.out.println(report);
            return;
        }
        try {
            Path path = Path.of(output, new String[0]);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, report.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private ImmutableList<PolicyStats> getSortedStats(Collection<PolicyStats> results) {
        String sortBy = results.stream().flatMap(policyStats -> policyStats.metrics().keySet().stream()).filter(header -> header.toLowerCase(Locale.US).equals(this.settings.report().sortBy().toLowerCase(Locale.US))).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown sort order: " + this.settings.report().sortBy()));
        return ImmutableSortedSet.copyOf(this.comparator(sortBy), results).asList();
    }

    private ImmutableSet<String> getHeaders(Collection<PolicyStats> results) {
        ImmutableSet columns = (ImmutableSet)results.stream().flatMap(policyStats -> policyStats.metrics().values().stream()).filter(metric -> {
            if (metric.characteristics().isEmpty()) return true;
            if (!metric.characteristics().stream().anyMatch(this.characteristics::contains)) return false;
            return true;
        }).filter(metric -> metric.required() || !this.metrics().format((PolicyStats.Metric)metric).isEmpty()).map(PolicyStats.Metric::name).collect(ImmutableSet.toImmutableSet());
        return (ImmutableSet)results.stream().flatMap(policyStats -> policyStats.metrics().keySet().stream()).filter(arg_0 -> ((ImmutableSet)columns).contains(arg_0)).collect(ImmutableSet.toImmutableSet());
    }

    protected abstract Metrics metrics();

    protected abstract String assemble(Set<String> var1, List<PolicyStats> var2);

    private Comparator<PolicyStats> comparator(String sortBy) {
        Comparator<PolicyStats> comparator = this.metrics().comparator(sortBy);
        return this.settings.report().ascending() ? comparator : comparator.reversed();
    }
}

