/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.report.AutoValue_Metrics;
import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;

@AutoValue
public abstract class Metrics {
    public abstract Function<Object, String> objectFormatter();

    public abstract DoubleFunction<String> percentFormatter();

    public abstract DoubleFunction<String> doubleFormatter();

    public abstract LongFunction<String> longFormatter();

    public String format(PolicyStats.Metric metric) {
        if (metric == null) {
            return "";
        }
        if (metric.value() instanceof LongSupplier) {
            long value = ((LongSupplier)metric.value()).getAsLong();
            return value > 0L || metric.required() ? this.longFormatter().apply(value) : "";
        }
        if (metric.value() instanceof DoubleSupplier) {
            double value = ((DoubleSupplier)metric.value()).getAsDouble();
            if (value == 0.0 && !metric.required()) {
                return "";
            }
            return metric.type() == PolicyStats.Metric.MetricType.PERCENT ? this.percentFormatter().apply(value) : this.doubleFormatter().apply(value);
        }
        if (metric.value() instanceof Supplier) {
            Object value = ((Supplier)metric.value()).get();
            return (String)MoreObjects.firstNonNull((Object)this.objectFormatter().apply(value), (Object)"");
        }
        return (String)MoreObjects.firstNonNull((Object)this.objectFormatter().apply(metric.value()), (Object)"");
    }

    public Comparator<PolicyStats> comparator(String header) {
        return new MetricComparator(header);
    }

    public static Builder builder() {
        return new AutoValue_Metrics.Builder().percentFormatter(value -> value == 0.0 ? "" : Double.toString(100.0 * value)).doubleFormatter(value -> value == 0.0 ? "" : Double.toString(value)).objectFormatter(object -> object == null ? "" : object.toString()).longFormatter(value -> value == 0L ? "" : Long.toString(value));
    }

    private final class MetricComparator
    implements Comparator<PolicyStats> {
        private final String header;

        public MetricComparator(String header) {
            this.header = Objects.requireNonNull(header);
        }

        @Override
        public int compare(PolicyStats p1, PolicyStats p2) {
            PolicyStats.Metric metric1 = p1.metrics().get(this.header);
            PolicyStats.Metric metric2 = p2.metrics().get(this.header);
            if (metric1 == null) {
                return metric2 == null ? 0 : -1;
            }
            if (metric2 == null) {
                return 1;
            }
            if (metric1.value() instanceof LongSupplier) {
                return Long.compare(((LongSupplier)metric1.value()).getAsLong(), ((LongSupplier)metric2.value()).getAsLong());
            }
            if (metric1.value() instanceof DoubleSupplier) {
                return Double.compare(((DoubleSupplier)metric1.value()).getAsDouble(), ((DoubleSupplier)metric2.value()).getAsDouble());
            }
            if (metric1.value() instanceof Supplier) {
                Object value1 = ((Supplier)metric1.value()).get();
                Object value2 = ((Supplier)metric2.value()).get();
                if (value1 instanceof Comparable) {
                    Comparable comparator = (Comparable)value1;
                    return comparator.compareTo(value2);
                }
                return Metrics.this.objectFormatter().apply(value1).compareTo(Metrics.this.objectFormatter().apply(value2));
            }
            return Metrics.this.objectFormatter().apply(metric1.value()).compareTo(Metrics.this.objectFormatter().apply(metric2.value()));
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder objectFormatter(Function<Object, String> var1);

        public abstract Builder percentFormatter(DoubleFunction<String> var1);

        public abstract Builder doubleFormatter(DoubleFunction<String> var1);

        public abstract Builder longFormatter(LongFunction<String> var1);

        public abstract Metrics build();
    }
}

