/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.table;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public final class RandomRemovalFrequencyTable
implements Frequency {
    private static final int sampleFactor = 8;
    private final Map<Long, Integer> table;
    private final Random random;
    private final int maxSum;
    private int currSum;

    public RandomRemovalFrequencyTable(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maxSum = Ints.checkedCast((long)(8L * settings.maximumSize()));
        this.random = new Random(settings.randomSeed());
        this.table = new HashMap<Long, Integer>(this.maxSum);
    }

    @Override
    public int frequency(long e) {
        return this.table.getOrDefault(e, 0);
    }

    @Override
    public void increment(long e) {
        ArrayList<Long> array;
        long itemToRemove;
        int value = this.table.getOrDefault(e, 0) + 1;
        if (value > 8) {
            return;
        }
        this.table.put(e, value);
        if (this.currSum < this.maxSum) {
            ++this.currSum;
        }
        if (this.currSum == this.maxSum && (value = this.table.remove(itemToRemove = ((Long)(array = new ArrayList<Long>(this.table.keySet())).get(this.random.nextInt(array.size()))).longValue()).intValue()) > 1) {
            this.table.put(itemToRemove, value - 1);
        }
    }
}

