/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.linked;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Policy.PolicySpec(characteristics={Policy.Characteristic.WEIGHTED})
public final class LinkedPolicy
implements Policy {
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final EvictionPolicy policy;
    final Admittor admittor;
    final long maximumSize;
    final boolean weighted;
    final Node sentinel;
    long currentSize;

    public LinkedPolicy(Config config, Set<Policy.Characteristic> characteristics, Admission admission, EvictionPolicy policy) {
        this.policyStats = new PolicyStats(admission.format(policy.label()), new Object[0]);
        this.admittor = admission.from(config, this.policyStats);
        this.weighted = characteristics.contains((Object)Policy.Characteristic.WEIGHTED);
        BasicSettings settings = new BasicSettings(config);
        this.data = new Long2ObjectOpenHashMap();
        this.maximumSize = settings.maximumSize();
        this.sentinel = new Node();
        this.policy = policy;
    }

    public static Set<Policy> policies(Config config, Set<Policy.Characteristic> characteristics, EvictionPolicy policy) {
        BasicSettings settings = new BasicSettings(config);
        return settings.admission().stream().map(admission -> new LinkedPolicy(config, characteristics, (Admission)((Object)admission), policy)).collect(Collectors.toSet());
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(AccessEvent event) {
        int weight = this.weighted ? event.weight() : 1;
        long key = event.key();
        Node old = (Node)this.data.get(key);
        this.admittor.record(key);
        if (old == null) {
            this.policyStats.recordWeightedMiss(weight);
            if ((long)weight > this.maximumSize) {
                this.policyStats.recordOperation();
                return;
            }
            Node node = new Node(key, weight, this.sentinel);
            this.data.put(key, (Object)node);
            this.currentSize += (long)node.weight;
            node.appendToTail();
            this.evict(node);
        } else {
            this.policyStats.recordWeightedHit(weight);
            this.currentSize += (long)(weight - old.weight);
            old.weight = weight;
            this.policy.onAccess(old, this.policyStats);
            this.evict(old);
        }
    }

    private void evict(Node candidate) {
        if (this.currentSize > this.maximumSize) {
            while (this.currentSize > this.maximumSize) {
                if ((long)candidate.weight > this.maximumSize) {
                    this.evictEntry(candidate);
                    continue;
                }
                Node victim = this.policy.findVictim(this.sentinel, this.policyStats);
                boolean admit = this.admittor.admit(candidate.key, victim.key);
                if (admit) {
                    this.evictEntry(victim);
                    continue;
                }
                this.evictEntry(candidate);
            }
        } else {
            this.policyStats.recordOperation();
        }
    }

    private void evictEntry(Node node) {
        this.policyStats.recordEviction();
        this.currentSize -= (long)node.weight;
        this.data.remove(node.key);
        node.remove();
    }

    static final class Node {
        final Node sentinel;
        boolean marked;
        Node prev;
        Node next;
        long key;
        int weight;

        public Node() {
            this.key = Long.MIN_VALUE;
            this.sentinel = this;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, int weight, Node sentinel) {
            this.sentinel = sentinel;
            this.key = key;
            this.weight = weight;
        }

        public void appendToTail() {
            Node tail = this.sentinel.prev;
            this.sentinel.prev = this;
            tail.next = this;
            this.next = this.sentinel;
            this.prev = tail;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
            this.key = Long.MIN_VALUE;
        }

        public void moveToTail() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = this.sentinel;
            this.prev = this.sentinel.prev;
            this.sentinel.prev = this;
            this.prev.next = this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("weight", this.weight).add("marked", this.marked).toString();
        }
    }

    public static enum EvictionPolicy {
        FIFO{

            @Override
            void onAccess(Node node, PolicyStats policyStats) {
                policyStats.recordOperation();
            }

            @Override
            Node findVictim(Node sentinel, PolicyStats policyStats) {
                policyStats.recordOperation();
                return sentinel.next;
            }
        }
        ,
        CLOCK{

            @Override
            void onAccess(Node node, PolicyStats policyStats) {
                policyStats.recordOperation();
                node.marked = true;
            }

            @Override
            Node findVictim(Node sentinel, PolicyStats policyStats) {
                Node node;
                while (true) {
                    policyStats.recordOperation();
                    node = sentinel.next;
                    if (!node.marked) break;
                    node.moveToTail();
                    node.marked = false;
                }
                return node;
            }
        }
        ,
        MRU{

            @Override
            void onAccess(Node node, PolicyStats policyStats) {
                policyStats.recordOperation();
                node.moveToTail();
            }

            @Override
            Node findVictim(Node sentinel, PolicyStats policyStats) {
                policyStats.recordOperation();
                return sentinel.prev.prev;
            }
        }
        ,
        LRU{

            @Override
            void onAccess(Node node, PolicyStats policyStats) {
                policyStats.recordOperation();
                node.moveToTail();
            }

            @Override
            Node findVictim(Node sentinel, PolicyStats policyStats) {
                policyStats.recordOperation();
                return sentinel.next;
            }
        };


        public String label() {
            return "linked." + StringUtils.capitalize((String)this.name().toLowerCase(Locale.US));
        }

        abstract void onAccess(Node var1, PolicyStats var2);

        abstract Node findVictim(Node var1, PolicyStats var2);
    }
}

