/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.membership.bloom;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.membership.Membership;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.typesafe.config.Config;

public final class GuavaBloomFilter
implements Membership {
    private final long expectedInsertions;
    private final double fpp;
    private BloomFilter<Long> bloomFilter;

    public GuavaBloomFilter(Config config) {
        BasicSettings.MembershipSettings settings = new BasicSettings(config).membership();
        this.expectedInsertions = settings.expectedInsertions();
        this.fpp = settings.fpp();
        this.reset();
    }

    @Override
    public boolean mightContain(long e) {
        return this.bloomFilter.mightContain((Object)e);
    }

    @Override
    public void clear() {
        this.reset();
    }

    @Override
    public boolean put(long e) {
        return this.bloomFilter.put((Object)e);
    }

    private void reset() {
        this.bloomFilter = BloomFilter.create((Funnel)Funnels.longFunnel(), (long)this.expectedInsertions, (double)this.fpp);
    }
}

