/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.snia.systor;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.math.IntMath;
import java.math.RoundingMode;
import java.util.Set;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class SystorTraceReader
extends TextTraceReader {
    static final int BLOCK_SIZE = 512;

    public SystorTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Set.of();
    }

    @Override
    public Stream<AccessEvent> events() {
        return this.lines().map(line -> line.split(",")).filter(array -> ((String[])array).length == 6).filter(array -> !array[1].isEmpty()).filter(array -> array[2].equals("R")).flatMap(array -> {
            int size = Integer.parseInt(array[5]);
            long offset = Long.parseLong(array[4]);
            double responseTime = 1000.0 * Double.parseDouble(array[1]);
            int sequence = IntMath.divide((int)size, (int)512, (RoundingMode)RoundingMode.UP);
            return LongStream.range(offset, offset + (long)sequence).mapToObj(key -> AccessEvent.forKeyAndPenalties(key, 0.0, responseTime));
        });
    }
}

