/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.report.AutoValue_Metrics;
import com.github.benmanes.caffeine.cache.simulator.report.Metrics;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.LongFunction;

public final class Metrics_Builder {
    private Function<Object, String> objectFormatter;
    private DoubleFunction<String> percentFormatter;
    private DoubleFunction<String> doubleFormatter;
    private LongFunction<String> longFormatter;

    private Metrics_Builder() {
    }

    private void init(Metrics input) {
        this.objectFormatter = input.objectFormatter();
        this.percentFormatter = input.percentFormatter();
        this.doubleFormatter = input.doubleFormatter();
        this.longFormatter = input.longFormatter();
    }

    public Metrics build() {
        AutoValue_Metrics result = new AutoValue_Metrics(this.objectFormatter, this.percentFormatter, this.doubleFormatter, this.longFormatter);
        return result;
    }

    public static Metrics_Builder builder() {
        return new Metrics_Builder();
    }

    public static Metrics_Builder toBuilder(Metrics input) {
        Metrics_Builder builder = new Metrics_Builder();
        builder.init(input);
        return builder;
    }

    public static Metrics_Builder builder(Metrics input) {
        return Metrics_Builder.toBuilder(input);
    }

    public final Metrics_Builder objectFormatter(Function<Object, String> objectFormatter) {
        this.objectFormatter = objectFormatter;
        return this;
    }

    public final Metrics_Builder percentFormatter(DoubleFunction<String> percentFormatter) {
        this.percentFormatter = percentFormatter;
        return this;
    }

    public final Metrics_Builder doubleFormatter(DoubleFunction<String> doubleFormatter) {
        this.doubleFormatter = doubleFormatter;
        return this;
    }

    public final Metrics_Builder longFormatter(LongFunction<String> longFormatter) {
        this.longFormatter = longFormatter;
        return this;
    }
}

